#!/usr/bin/python
# sort-channel_list.py  by Ambrosa http://www.dreamboxonline.com
# sort alphabetically a channel_list.conf file

__author__ = "ambrosa http://www.dreamboxonline.com"
__version__ = "0.02 beta"
__copyright__ = "Copyright (C) 2009 Alessandro Ambrosini"
__license__ = "CreativeCommons by-nc-sa http://creativecommons.org/licenses/by-nc-sa/3.0/"

import os
import sys
import time
import codecs
import string

# force output to UTF-8
sys.stdout = codecs.getwriter('utf-8')(sys.stdout)


if len(sys.argv) != 2 :
    print "Sort alphabetically a channel_list.conf file"
    print "It can be useful for finding duplicated channel names\n"
    print "Usage:"
    print "   sort-channel_list.py   : show this help"
    print "   sort-channel_list.py module   : process module-channel_list.conf\n"
    print "Examples:"    
    print "   sort-channel_list.py  bskybsat   : order bskybsat-channel_list.conf and output to video"
    print "   sort-channel_list.py  bskybsat > dummy.txt   : order bskybsat-channel_list.conf and output to dummy.txt file\n"
    sys.exit(0)

fd=codecs.open(sys.argv[1]+"-channel_list.conf","r",'utf-8')

while True:
    buf=string.strip(fd.readline())
    if buf != "[channel_list]":
        print buf
        continue
    else:
        break
    
print buf+"\n"
chlist={}
end=False

while True:
    while True:
        buf1=fd.readline()
        if buf1 == "":
            end=True
            break
        buf1=string.lower(string.strip(buf1))
        if len(buf1) < 5:
            continue
        if buf1[:1] != '#':
            continue
        break
    if end == True :
        break
    
    while True:
        buf2=fd.readline()
        if buf2 == "" :
            end=True
            break
        buf2=string.lower(string.strip(buf2))
        if len(buf2) < 5:
            continue
        break

    if end == True :
        break
    
    key=string.strip(string.split(buf1[1:],',')[0])
    data=(buf1,buf2)
    if chlist.has_key(key) == True:
        chlist[key]=chlist[key]+data
    else:
        chlist[key]=data


for c in sorted(chlist):
    
    for d in chlist[c]:
        print d
        
    
fd.close()

