#!/usr/bin/python
# channel_list_generator.py
#
# Sniff remote url find channels ID and
# write default channel_list configuration file
#
# WARNING : existing channel_list file will be overwritten/destroyed
#           make backup before running channel_list_generator.py
#
# see e2_loadepg.conf for common options
#

__author__ = "ambrosa http://www.dreamboxonline.com"
__version__ = "0.50 beta"
__copyright__ = "Copyright (C) 2008-2009 Alessandro Ambrosini"
__license__ = "CreativeCommons by-nc-sa http://creativecommons.org/licenses/by-nc-sa/3.0/"

import urllib2
import codecs
import socket
import time
import sys
import os.path
import string
from xml.dom import minidom

# ****** CONSTANT ******

# retry number if HTTP error
HTTP_ERROR_RETRY = 3
HTTP_ERROR_WAIT_RETRY=10
HTTP_QUIT_NOERROR=-1
HTTP_QUIT_404=-10


CONF_URL="http://xmltv.tvsajten.com/xmltv/channels.xml.gz"
CONF_CHLIST="tvsajten-channel_list.conf"
CONF_SOCKET_TIMEOUT=20
CONF_LOG_LEVEL=2


BIN_GZUNZIP="gunzip"
GZTMP_FILE="gunzip_temp.gz"
UNGZTMP_FILE="gunzip_temp"

def gzuncompress(data_gz):
    fd=open(GZTMP_FILE,'w')
    fd.write(data_gz)
    fd.close()
    os.system(BIN_GZUNZIP+" "+GZTMP_FILE)
    fd=open(UNGZTMP_FILE,'r')
    data_ungz=fd.read()
    fd.close()
    os.unlink(UNGZTMP_FILE)
    return(data_ungz)

# ---------------------------------------------------------------------------



# ****** FUNCTION ******

def log(s,level=1):
    if (CONF_LOG_LEVEL>0):
        if (level<=CONF_LOG_LEVEL):
            print time.strftime("%d-%m-%Y %H:%M:%S",time.localtime()),
            if type(s).__name__=='str':
                s=s.decode('utf-8')
            print " " + s.encode('ascii','replace')
    
    
def confirm(s):
    print s,
    while True:
        ok = raw_input()
        if ok in ('y','yes'): return True
        if ok in ('n','no'): return False


# -------------------------------------------------------------------------


# ****** MAIN CODE ******


if not confirm("Warning ! File channel_list.conf will be overwritten ! " \
                "Continue [y/n] ?"):
    sys.exit(2)
    

START_TIME=time.time()

# set socket timeout
socket.setdefaulttimeout(CONF_SOCKET_TIMEOUT)

log("Open for writing " + CONF_CHLIST,2)
conf=codecs.open(CONF_CHLIST,'w','utf-8')

confheader="# TVSAJTEN channel_list_generator.py  by " + __author__ + " , rel. " + __version__ + "\n" + \
        "# Creation time: " + time.strftime("%d-%m-%Y %H:%M:%S",time.localtime()) + "\n" \
    "#\n" + \
    "# YOU must configure every channel ID\n" + \
    "#\n" + \
    "# id=0   EPG will not be downloaded\n" + \
	"# id=1,DM7025_channel_name[,provider_name]   EPG will be downloaded and cached, optional set provider_name if it's different from 'defaul_provider'\n" + \
	"# id=2,DM7025_channel_name[,provider_name]   EPG will be downloaded every time\n" + \
	"# id=3,DM7025_channel_name[,provider_name]   EPG will be downloaded and cached (like '1') but only TODAY will be forced downloading (like '2')\n" + \
	"#\n" + \
	"# Examples:\n" + \
	"# EUROSPORT2=0        channel 'EUROSPORT2' EPG will NOT be dowloaded\n" + \
	"# Ten-Qld=1,Ten Qld   'Ten-Qld' EPG will be dowloaded and cached and name in DM is 'Ten Qld'\n" + \
	"# ABC-NSW=2,ABCNEWS   'ABC-NSW' EPG will be dowloaded every time and it's name in DM is 'ABCNEWS'\n" + \
	"# FOX8+2=1,fox8 2,globecast uk    'FOX8+2' EPG will be dowloaded and cached and name in DM is 'fox8 2' and it's provider is 'globecast uk'\n" + \
	"# UKTV=2,uk television,noprovider         'UKTV' EPG will be dowloaded every time, name in DM is 'uk television' and it's provider is 'noprovider'\n" + \
	"#                                         (special case where there are no provider assigned)\n" + \
	"#\n" + \
    "# note 1a: channel ID IS CASE SENSITIVE\n" + \
	"# note 1b: channel name and provider name are case insensitive\n" + \
	"# note 2: if provider name is empty use the special word 'noprovider'\n" + \
	"# note 3: you can add many providers using '|' character as separator but you MUST also include the default_provider\n" + \
	"#            i.e.  UKTV=1,uk television,foxtel|opt|noprovider\n" + \
        "\n\n[default_provider]\nPROVIDER=telenor\n" + \
        "\n\n[channel_list]\n\n"

conf.write(confheader)

TODAY=time.strftime("%Y%m%d",time.localtime())

log("Start fetching channel list from " + CONF_URL)

# read remote file
i = HTTP_ERROR_RETRY
while i > 0 :
    try:
        sock=urllib2.urlopen(CONF_URL)
        data=sock.read()

    except IOError, e:
        serr="unknown"
        if hasattr(e, 'reason'):
            serr=str(e.reason)
        elif hasattr(e, 'code'):
            serr=str(e.code)
            if hasattr(e, 'msg'):
                serr+=" , "+str(e.msg)
            if e.code==404:
                log("  connection error. Reason: "+serr+". Skip it.")
                i=HTTP_QUIT_404
                
        if i != HTTP_QUIT_404:
            log("  connection error. Reason: "+serr+". Waiting "+str(HTTP_ERROR_WAIT_RETRY)+" sec. and retry ["+str(i)+"] ...")
            time.sleep(HTTP_ERROR_WAIT_RETRY) # add sleep
            i -= 1 
                
    else:
        i=HTTP_QUIT_NOERROR # quit WHILE loop
        sock.close()        
        
        
if i != HTTP_QUIT_NOERROR :
    log("Download error. Abort process")
    sys.exit(1)

data=gzuncompress(data)


                
# start parsing XML code
xmldoc = minidom.parseString(data)
for x in xmldoc.getElementsByTagName('channel'):
    chid=x.attributes["id"].value
    
    dspname=x.getElementsByTagName('display-name')[0].firstChild.data
    

    sout=dspname + "  , id=" + chid     
    log("   found channel \"" + sout + "\"")
    sout="# " + sout + "\n" +  chid + "=1,"+string.lower(dspname)+"\n"
    conf.write(sout)


conf.close()

log("Saved file " + CONF_CHLIST,2)

END_TIME=time.time()    
log("End processing, elapsed " + str(int(END_TIME - START_TIME)) + " seconds")


sys.exit(0)

# **************** E N D ********************
