#!/usr/bin/python
# -*- coding: utf-8 -*-

# tvsajten.py  by Ambrosa http://www.dreamboxonline.com
# this module is used for download EPG data from OZTIVO website
#

__author__ = "ambrosa http://www.dreamboxonline.com"
__version__ = "0.52 beta"
__copyright__ = "Copyright (C) 2008-2009 Alessandro Ambrosini"
__license__ = "CreativeCommons by-nc-sa http://creativecommons.org/licenses/by-nc-sa/3.0/"

import os
import time
import socket
import codecs
import string
import random
import urllib2
import ConfigParser
from xml.dom import minidom

from e2_coremod.stuff import fn_escape
from e2_coremod.stuff import zlib_class


class download_and_cache:
    

    # retry number if HTTP error
    HTTP_ERROR_RETRY = 3

    # seconds to wait between retries
    HTTP_ERROR_WAIT_RETRY=10


    # =================================================================

    CONF_FILENAME=''
    CONF_SOCKET_TIMEOUT=0.0
    CONF_CHLIST=''
    CONF_MAX_DAY_EPG=7
    CONF_RANDOM_MIN=0.0
    CONF_RANDOM_MAX=1.0
    CONF_URL=''
    CONF_DEFAULT_PROVIDER=''
    CONF_CACHEDIR='cache'
    
    TODAY=''
    DAYCACHE=[]
    FIELD_SEPARATOR=''
    
    
    def log_dummy(self,s,l):
        pass
    log=log_dummy
        
    def set_log_function(self,lf):
        self.log=lf

    def set_webif_function(self,wi):
        self.webif=wi
        self.CONF_USE_WEBIF=self.webif.get_use_webif()
        
    def __init__(self,dldir,cachedir,separator):
        
        self.CONF_CACHEDIR=cachedir
        self.FIELD_SEPARATOR=separator
        
        self.CONF_FILENAME=os.path.join(dldir,'tvsajten.conf')
        config=ConfigParser.ConfigParser()
        config.read(self.CONF_FILENAME)
        self.CONF_SOCKET_TIMEOUT=config.getfloat("tvsajten","SOCKET_TIMEOUT")
        self.CONF_CHLIST=os.path.join(dldir,config.get("tvsajten","CHLIST"))
        self.CONF_MAX_DAY_EPG=config.getint("tvsajten","MAX_DAY_EPG")
        self.CONF_RANDOM_MIN=config.getfloat("tvsajten","RANDOM_MIN")
        self.CONF_RANDOM_MAX=config.getfloat("tvsajten","RANDOM_MAX")

        self.CONF_URL=config.get("tvsajten","URL")
        if self.CONF_URL[-1] != "/":
            self.CONF_URL += "/"


        self.TODAY=time.strftime("%Y%m%d")
        self.OZTODAY=time.strftime("%Y-%m-%d")
        
        # create a list filled with dates (format AAAAMMDD) from today to today+ MAX_DAY_EPG
        self.DAYCACHE=[self.TODAY]
        self.OZDAYCACHE=[self.OZTODAY]
        for day in range(1,self.CONF_MAX_DAY_EPG):
            self.DAYCACHE.append(time.strftime("%Y%m%d",time.localtime(time.time()+86400*day)))
            self.OZDAYCACHE.append(time.strftime("%Y-%m-%d",time.localtime(time.time()+86400*day)))




# =================================================================


    # get XML file from OZTIVO website
    def start(self):
        
        gz=zlib_class()

        
        # ** read channel_list.conf file **
        if not os.path.exists(self.CONF_CHLIST):
            self.log("ERROR ! \'" + self.CONF_CHLIST + "\' NOT FOUND");
            sys.exit(10)
       
        self.log("Reading \'" + self.CONF_CHLIST+"\'",2)
        config=ConfigParser.ConfigParser()
        config.optionxform = str  # OZTIVO: needed for return case sensitive index
        config.read(self.CONF_CHLIST)
        self.CONF_DEFAULT_PROVIDER=string.lower(config.get("default_provider","PROVIDER"))
        
        temp=config.items("channel_list");
        
        chlist={}

        # create a dictionary (Python array) with index=channel ID
        for i in temp:
            chlist[unicode(i[0],'utf-8')]=unicode(i[1],'utf-8')
        
        if len(chlist) == 0 :
            self.log("ERROR ! \'" + self.CONF_CHLIST + "\' empty ?")
            sys.exit(10)

        # set network socket timeout
        socket.setdefaulttimeout(self.CONF_SOCKET_TIMEOUT)

        self.log("Start download XML files from \'" + self.CONF_URL+"\'")
        
        random.seed() # initialize random generator


        # get remote XML files
        #   chid format: channel id , 0|1|2(,new name)
        #   i.e. ("101" , "1,SkyCinema1")
        for c in sorted(chlist.keys()):
            # get cacheopt
            #  0 : don't download/cache
            #  1 : download and cache (optional 1,new_name )
            #  2 : always download overwriting existing files (optional 2,new_name )
            #  3 : always download overwriting existing files only for TODAY (optional 2,new_name )
            
            
            cacheopt=int(string.split(chlist[c],",")[0])
        
            # if cacheopt == 0, do nothing
            if cacheopt == 0:
                continue
        
            channel_name=''
            if (len(string.split(chlist[c],",")) >= 2) and (string.split(chlist[c],",")[1]!=''):
                # channel renamed into DM7025, new name provided by user in channel_list.conf
                channel_name=string.lower(string.strip(string.split(chlist[c],",")[1]))
                
            if (len(string.split(chlist[c],",")) >= 3) and (string.split(chlist[c],",")[2]!=''):
                channel_provider=string.lower(string.strip(string.split(chlist[c],",")[2]))
            else:
                channel_provider=self.CONF_DEFAULT_PROVIDER

            for d in range(0,len(self.OZDAYCACHE)):
                xmlfile=c + "_" + self.OZDAYCACHE[d] + ".xml.gz"
                
                
                # download only if file doesn't exist or cacheopt == 2 (always download),
                # using open(...,"w") files will be overwritten (saving a delete + create)
                            
                if channel_name != '':
                    eventfilename=fn_escape("tvsajten" + self.FIELD_SEPARATOR + channel_name + self.FIELD_SEPARATOR + self.DAYCACHE[d])
                    eventfilepath=os.path.join(self.CONF_CACHEDIR,eventfilename)
                    if (cacheopt == 1) and  os.path.exists(eventfilepath):
                        continue
                    if (cacheopt == 3) and os.path.exists(eventfilepath) and (self.DAYCACHE[d] != self.TODAY):
                        continue
                    
                # read remote file
                self.log("Downloading \'" + xmlfile+"\'",2)
                i = self.HTTP_ERROR_RETRY
                while i > 0  :
                    # to avoid overloading website, wait randomly
                    time.sleep(random.uniform(self.CONF_RANDOM_MIN,self.CONF_RANDOM_MAX))
                    
                    try:
                        sock=urllib2.urlopen(self.CONF_URL + xmlfile)
                        data=sock.read()
                        
                    except IOError, e:
                        serr="unknown"
                        if hasattr(e, 'reason'):
                            serr=str(e.reason)
                        elif hasattr(e, 'code'):
                            serr=str(e.code)
                            if hasattr(e, 'msg'):
                                serr+=" , "+str(e.msg)
                            if e.code==404:
                                self.log("\'" + xmlfile+"\' connection error. Reason: "+serr+". Skip it.")
                                i=0
                                continue
                        self.log("\'" + xmlfile+"\' connection error. Reason: "+serr+". Waiting "+str(self.HTTP_ERROR_WAIT_RETRY)+" sec. and retry ["+str(i)+"] ...")
                        time.sleep(self.HTTP_ERROR_WAIT_RETRY) # add sleep
                        i -= 1                            
                            
                    else:
                        i=0 # quit WHILE loop
                        sock.close()
                        data=gz.gzuncompress(data)
                        
                        try:
                            xmldoc = minidom.parseString(data)
                                
                        except:
                            self.log("Warning ! " + xmlfile + " is not a valid XML file. Skipped.")
                            continue
            
                        # get the ref to the first XML "<channel>" section (there is only 1 "<channel>" section)
                        xmlref_programme=xmldoc.getElementsByTagName('programme')
                        
                        # if channel name is not present as option in channel_list.conf , get it from XML file
                        if channel_name == '':
                            channel_name=string.lower(string.strip(xmlref_programme[0].attributes["channel"].value))
                            
                            eventfilename=fn_escape("tvsajten" + self.FIELD_SEPARATOR + channel_name + self.FIELD_SEPARATOR + self.DAYCACHE[d])
                            eventfilepath=os.path.join(self.CONF_CACHEDIR,eventfilename)
                            # download only if file doesn't exist or cacheopt == 2 (always download),
                            # using open(...,"w") files will be overwritten (saving a delete + create)
                            if (cacheopt == 1) and  os.path.exists(eventfilepath):
                                continue
                            if (cacheopt == 3) and os.path.exists(eventfilepath) and (self.DAYCACHE[d] != self.TODAY):
                                continue
                            
                        self.log("  Writing in cache \'"+eventfilename+"\'",2)
                        fd=codecs.open(eventfilepath,"w",'utf-8')
                        fd.write(channel_name + self.FIELD_SEPARATOR + channel_provider + self.FIELD_SEPARATOR + c + '\n')
                        
                        # get the refs to all XML "<event>" inside the "<channel>" section
                        #xmlref_events=xmlref_channel.getElementsByTagName('event')
            
                        # extract all events and put in eventfile
                        for xml_event in xmlref_programme:
                            # #event_id=int(string.strip(xml_event.attributes["id"].value))
                            try:
                                event_title=string.strip(xml_event.getElementsByTagName('title')[0].firstChild.data)
                            except:
                                event_title=u'no title available'
                            else:
                                #event_title=event_title.encode('ascii','replace')
                                event_title=event_title.replace('\n','  ')
                            
                            try:
                                event_description=string.strip(xml_event.getElementsByTagName('desc')[0].firstChild.data)
                            except:
                                event_description=u'no description available'
                            else:
                                #event_description=event_description.encode('ascii','replace')
                                event_description=event_description.replace('\n','  ')
                            
                            try:
                                event_description_date=string.strip(xml_event.getElementsByTagName('date')[0].firstChild.data)
                            except:
                                pass
                            else:
                                event_description=event_description + " ("+event_description_date+") "
                            
                            try:
                                event_description_directors=xml_event.getElementsByTagName('director')
                            except:
                                pass
                            else:
                                event_description=event_description+u"Regissör "
                                for d in event_description_directors:
                                    event_description=event_description + d.firstChild.data + ","
                                event_description=event_description[:-1]
                            
                            try:
                                event_description_actors=xml_event.getElementsByTagName('actor')
                            except:
                                pass
                            else:
                                event_description=event_description+u" Skådespelare "
                                for a in event_description_actors:
                                    event_description=event_description + a.firstChild.data + ","
                                event_description=event_description[:-1]
                            
                            event_starttime=string.strip(xml_event.attributes['start'].value)
                            gmt_delta=int(event_starttime[16:18])*3600 + int(event_starttime[18:20])*60
                            if event_starttime[15] == '-' :
                                gmt_delta=-gmt_delta
                            
                            event_startime_unix_gmt=str( int(time.mktime(time.strptime(event_starttime[:14],"%Y%m%d%H%M%S"))) - gmt_delta)
    
                            fd.write(event_startime_unix_gmt+self.FIELD_SEPARATOR+event_starttime+self.FIELD_SEPARATOR+event_title+self.FIELD_SEPARATOR+event_description+'\n')
                
                
                        fd.close()

# ****************************************************************************************************************************
