#!/usr/bin/python
# stuff.py  by Ambrosa http://www.dreamboxonline.com

__author__ = "ambrosa http://www.dreamboxonline.com"
__version__ = "0.51 beta"
__copyright__ = "Copyright (C) 2008-2009 Alessandro Ambrosini"
__license__ = "CreativeCommons by-nc-sa http://creativecommons.org/licenses/by-nc-sa/3.0/"


import os
import codecs
from datetime import datetime

# escape some incorrect char from filename
def fn_escape(s):
    if type(s).__name__ == 'str':
        s=s.decode('utf-8')
        
    s=s.replace('/',' ')
    s=s.replace(':',' ')

    return(s.encode('utf-8'))


class logging_class:   
    LOG_VIDEO=0
    LOG_FILE=0
    LOG_LEVEL=0
    LOG_FILENAME='e2_loadepg.log'
    LOG_PREFIX=''
    LOG_FD=0
    
    def __init__(self,lv,lf,ll,lp):
        self.LOG_VIDEO=lv
        self.LOG_FILE=lf
        self.LOG_LEVEL=ll
        self.LOG_FILENAME=os.path.join(lp,self.LOG_FILENAME)
        if os.path.exists(self.LOG_FILENAME):
            os.unlink(self.LOG_FILENAME)
        self.LOG_FD=codecs.open(self.LOG_FILENAME,"a",'utf-8')
    
    def set_logprefix(self,s):
        self.LOG_PREFIX=s+' '


    def reset_logprefix(self):
        self.LOG_PREFIX=''
        
    def log(self,s,level=1,raw=0):
        
        if level <= self.LOG_LEVEL:
            
            if raw==0:
                sl = datetime.now().strftime("%d-%m-%Y %H:%M:%S") + ' ' + self.LOG_PREFIX + s
            else:
                sl = s
                
            if type(sl).__name__ == 'str':
                # convert 'sl' from simple string type to unicode utf-8 type
                sl=sl.decode('utf-8')
                
            if self.LOG_VIDEO == 1:
                # for safety reason, video output use ASCII charset
                print sl.encode('ascii','replace')
                
                
            if self.LOG_FILE == 1:
                self.LOG_FD.write(sl+'\n')


class zlib_class:
    GZTMP_FILE="gunzip_temp.gz"
    UNGZTMP_FILE="gunzip_temp"
    BIN_GZUNZIP="gunzip -c " + GZTMP_FILE
    
    def gzuncompress(self,data):
        fd=open(self.GZTMP_FILE,'w')
        fd.write(data)
        fd.close()
        
        fd=os.popen(self.BIN_GZUNZIP)
        data_ungz=fd.read()
        fd.close()
        os.unlink(self.GZTMP_FILE)
        return(data_ungz)


