#!/usr/bin/python

# e2_loadepg.py  by Ambrosa http://www.dreamboxonline.com

__author__ = "ambrosa http://www.dreamboxonline.com"
__version__ = "0.52 beta , 26 Mar 2009"
__copyright__ = "Copyright (C) 2008-2009 Alessandro Ambrosini"
__license__ = "CreativeCommons by-nc-sa http://creativecommons.org/licenses/by-nc-sa/3.0/"

import gc
import os
import sys
import time
import codecs
import string
import struct
import ConfigParser
from datetime import datetime

from e2_coremod import epgdat
from e2_coremod import webif
from e2_coremod import stuff



# ***********************************************************
# **                       CONSTANT                        **
# ***********************************************************


# installation directories
CONF_INSTALLDIRS=['/media/cf/e2_loadepg/','/media/usb/e2_loadepg/','/media/hdd/e2_loadepg/']

# main configuration filename
CONF_FILENAME="e2_loadepg.conf"

# download modules location
DLMODDIR='dl_modules'

# caching dir
CACHEDIR='cache'

# OS RESTART GUI COMMAND (no more used since ver. 0.20)
#RESTART_GUI_COMMAND='killall -HUP enigma2 2>/dev/null'


# three-chars field separator user for cached files and data into 
FIELD_SEPARATOR="###"


# ***********************************************************

# ***********************************************************
# **                      FUNCTION                         **
# ***********************************************************


    
# check configuration file
def check_conf_file(cd,n):
    for f in cd:
        if os.path.exists(os.path.join(f, n)):
             return f
    
    print "ERROR ! NOT FOUND " + n + " (not in " + str(cd) + " )"
    print "ABORTING"
    return None




# ***********************************************************


# ***********************************************************
# **                      MAIN CODE                        **
# ***********************************************************

# used for total elapsed time
START_TIME=int(time.time())
   
# install dir ?
INSTALLDIR=check_conf_file(CONF_INSTALLDIRS,CONF_FILENAME)
if INSTALLDIR == None :
    sys.exit(10)


# set Garbage Collector to do a "generational jump" more frequently than default 700
# memory saving: about 50% (!!), some performance loss (obviously)
gc.set_threshold(50,10,10)

# increase this process niceness (other processes have priority)
os.nice(10)

# ***********************************************************
# ** get configuration options **

config=ConfigParser.ConfigParser()
config.read(os.path.join(INSTALLDIR,CONF_FILENAME))

CONF_LOG_VIDEO=config.getint("e2_loadpeg","LOG_VIDEO")
CONF_LOG_FILE=config.getint("e2_loadpeg","LOG_FILE")
CONF_LOG_LEVEL=config.getint("e2_loadpeg","LOG_LEVEL")


# initialize log class
logging=stuff.logging_class(CONF_LOG_VIDEO,CONF_LOG_FILE,CONF_LOG_LEVEL,INSTALLDIR)
log=logging.log


log("E2_LOADEPG by " + __author__ + " , ver. " + __version__)
log("License: " + __license__)
log(__copyright__)

CONF_USE_WEBIF=config.getint("e2_loadpeg","USE_WEBIF")
CONF_USE_WEBIF_AUTH=config.getint("e2_loadpeg","USE_WEBIF_AUTH")
CONF_WEBIF_AUTH_USER=config.get("e2_loadpeg","WEBIF_AUTH_USER")
CONF_WEBIF_AUTH_PASSW=config.get("e2_loadpeg","WEBIF_AUTH_PASSW")
CONF_WEBIF_AUTH_REALM=config.get("e2_loadpeg","WEBIF_AUTH_REALM")
CONF_WEBIF_IP=config.get("e2_loadpeg","WEBIF_IP")

CONF_RESTART_GUI=config.getint("e2_loadpeg","RESTART_GUI")
CONF_STANDBY_AFTER_RESTART=config.getint("e2_loadpeg","STANDBY_AFTER_RESTART")
CONF_ENABLE_OSD=config.getint("e2_loadpeg","ENABLE_OSD")

CONF_EXSID=config.get("e2_loadpeg","EXSID")

CONF_CACHEDIR=os.path.join(INSTALLDIR,CACHEDIR)

CONF_LAMEDB=config.get("e2_loadpeg","LAMEDB")

CONF_EPGDAT=config.get("e2_loadpeg","EPGDAT")
CONF_EPG_CHARSET=config.get("e2_loadpeg","EPG_CHARSET")


CONF_LITTLE_ENDIAN=config.getint("e2_loadpeg","LITTLE_ENDIAN")
LB_ENDIAN='<'  # used by struct.pack() , '<' means LITTLE_ENDIAN
if CONF_LITTLE_ENDIAN == 0 :
    LB_ENDIAN='>'  # used by struct.pack() , '>' means BIG_ENDIAN


CONF_DL_MODULES=string.split(config.get("e2_loadpeg","DOWNLOAD_MODULES"),",")

CONF_DLMODDIR=os.path.join(INSTALLDIR,DLMODDIR)
log("OK, parsed \'" + CONF_FILENAME + "\' in \'" + INSTALLDIR+"\'",2)


# initialize WebInterface class
webif=webif.webif_class(CONF_USE_WEBIF,CONF_USE_WEBIF_AUTH,CONF_WEBIF_AUTH_USER,CONF_WEBIF_AUTH_PASSW,CONF_WEBIF_AUTH_REALM,CONF_WEBIF_IP)


if CONF_USE_WEBIF==1 and CONF_ENABLE_OSD==1:
    webif.message("START UPDATING EPG",7)
    time.sleep(7)


# ***********************************************************
# ** cleanup old tmp files **

    
if os.path.exists(CONF_EPGDAT):
    log("Removing old "+CONF_EPGDAT,2)
    os.unlink(CONF_EPGDAT)


# ***********************************************************
# ** read excluded_sid.conf file **
if not os.path.exists(os.path.join(INSTALLDIR,CONF_EXSID)):
    log("ERROR ! \'" + CONF_EXSID + "\' NOT FOUND");
    sys.exit(10)
   
log("Reading \'" + CONF_EXSID+"\'",2)
config=ConfigParser.RawConfigParser()
config.read(os.path.join(INSTALLDIR,CONF_EXSID))
temp=config.items("excluded_sid");
exsidlist=[]

# create a list with sids
for i in temp:
    sid=str.strip(i[0]) + ":" + str.strip(i[1])
    exsidlist.append(sid)


# *********************************************************** 
# ** create caching dir if not exist **
if not os.path.exists(CONF_CACHEDIR):
    log("Create \'" + CONF_CACHEDIR + "\' directory for caching",2)
    os.mkdir(CONF_CACHEDIR)



# ***********************************************************
# ** removing old cached epg files **

# today date, format AAAAMMDD
TODAY=datetime.now().strftime("%Y%m%d")

log("Removing old cached files",2)
for cachedfile in os.listdir(CONF_CACHEDIR):
    # extract date from filename
    
    if string.split(cachedfile,FIELD_SEPARATOR)[-1] < TODAY :
        os.unlink(os.path.join(CONF_CACHEDIR,cachedfile))
        log("Deleting old cached file \'" + cachedfile + "\'",2)


# ***********************************************************
# ** INITIALIZE EPGDAT CLASS **


# epgdat_class(temp dir path ,lamedb file path, epg.dat file path )
epg=epgdat.epgdat_class(INSTALLDIR, CONF_LAMEDB, CONF_EPGDAT)
epg.set_log_function(log)
epg.set_endian(LB_ENDIAN)
epg.set_excludedsid(exsidlist)


# ***********************************************************
# ** fetching EPG DATA **


if CONF_USE_WEBIF == 1:
    dm_is_switched_on=webif.currentchannelsid()


# run each download module

fetchdata_run=False
for mod_name in CONF_DL_MODULES:
    logging.reset_logprefix()
    if mod_name != '':
        log("Read EPG DATA using module \""+mod_name+"\"")
        logging.set_logprefix('['+mod_name+']')
        if CONF_USE_WEBIF==1 and CONF_ENABLE_OSD==1:
            webif.message("START download EPG data using module \'"+mod_name+"\'",7)
            time.sleep(7)
        
        exec('import '+DLMODDIR+'.' + mod_name)
        exec('fetchdata='+DLMODDIR+'.'+ mod_name +'.download_and_cache(CONF_DLMODDIR,CONF_CACHEDIR,FIELD_SEPARATOR)')
        fetchdata.set_log_function(log)
        fetchdata.set_webif_function(webif)
        fetchdata.start()
        fetchdata_run=True
        
        log("--------- End download epg data ---------")
        if CONF_USE_WEBIF==1 and CONF_ENABLE_OSD==1:
            webif.message("END download EPG data with module \'"+mod_name+"\'",10)
            time.sleep(10)

logging.reset_logprefix()

if fetchdata_run == True:
    # remove class for saving some memory
    del fetchdata


# ***********************************************************
# ** epg.dat creation ***

log("Starting creation \'" + CONF_EPGDAT+"\'",2);

if CONF_USE_WEBIF==1 and CONF_ENABLE_OSD==1:
    webif.message("Starting creation EPG.DAT file, please wait about 10-20 min",60)


total_events=0
group_events=0


previous_cn=u'!*!START_LOOP!*!'
real_cn=u'!*!START_LOOP!*!'
for f in sorted(os.listdir(CONF_CACHEDIR)):
            
    current_cn=string.lower(string.strip(string.split(f,FIELD_SEPARATOR)[1]))
    current_cn=current_cn.decode('utf-8')
    if current_cn != previous_cn:
        if previous_cn != u'!*!START_LOOP!*!':
            epg.preprocess_events_channel(real_cn,real_provider)

        previous_cn=current_cn
    
    log("Reading \'"+f+"\'",2)
    # process events and insert them in event_dict
    fd=codecs.open(os.path.join(CONF_CACHEDIR,f),"r","utf-8")
    events=fd.readlines()
    fd.close
    
    real_cn=string.split(events[0],FIELD_SEPARATOR)[0]
    real_provider=string.split(events[0],FIELD_SEPARATOR)[1]
    
    group_events=0
    for i in range(1,len(events)):
        total_events += 1
        group_events += 1
        event=events[i]
        
        event_starttime_unix_gmt=int(string.strip(string.split(event,FIELD_SEPARATOR)[0]))
        #event_starttime_notused=string.strip(string.split(event,FIELD_SEPARATOR)[1])) # not used
        event_title=string.strip(string.split(event[:250],FIELD_SEPARATOR)[2]) # max 250 chars for title
        event_description=string.strip(string.split(event[:1000],FIELD_SEPARATOR)[3]) # max 1000 chars for summarie

        epg.add_event(event_starttime_unix_gmt,event_title.encode(CONF_EPG_CHARSET,'replace'),event_description.encode(CONF_EPG_CHARSET,'replace'))
        


# process last group of files, if any
if group_events > 0:
    epg.preprocess_events_channel(real_cn,real_provider)

log("Processed "+str(total_events)+" events",2)

# create epg.dat
epg.final_process()


if CONF_USE_WEBIF==1 and CONF_ENABLE_OSD==1:
    webif.message("EPG.DAT file created, processed "+str(total_events)+" events",15)
    time.sleep(17)


# ***********************************************************


# restart GUI


if CONF_USE_WEBIF == 1:
    
    if CONF_RESTART_GUI == 1:
        if webif.is_recording() == False:
            log("Restarting ENIGMA2 GUI")
            if CONF_ENABLE_OSD==1:
                webif.message("Restarting ENIGMA2 GUI in few seconds... please wait 2 min",15)
                time.sleep(17)
            
            webif.restartenigma()
            log("Wait Restart GUI to finish (120 seconds)...",2)
            time.sleep(120)
            
            if CONF_ENABLE_OSD==1:
                webif.message("ALL DONE ! EPG updated correctly.",30)
                time.sleep(32)
        
            if CONF_STANDBY_AFTER_RESTART == 1:
                log("Switch to StandBy mode",2)
                webif.standby()
                
            if CONF_STANDBY_AFTER_RESTART == 2 and dm_is_switched_on==None:  # if dm_is_on == None --> DM was switched off
                log("Switch to StandBy mode",2)
                webif.standby()
            
            
        else:
            log("Recording in place. Restarting ENIGMA2 GUI not available")
            if CONF_ENABLE_OSD==1:
                webif.message("Recording in place. You must restart ENIGMA2 GUI manually.",300,3)
            

log("End processing, elapsed " + str(int(time.time()) - START_TIME) + " seconds")

sys.exit(0)

# **************** E N D ********************
