# -*- coding: utf-8 -*-
from Screens.Screen import Screen
from Components.Sources.StaticText import StaticText
from Components.ActionMap import ActionMap
from Components.Label import Label
from enigma import getDesktop
from enigma import eLabel, eSize, eTimer

import socket
import time
import requests

sz_w = getDesktop(0).size().width()

class TestPluginScreen(Screen):
	if sz_w == 1920:	#1920 x 1080 FHD
		skin = """
		<screen name="TestPluginScreen" position="200,200" size="1220,680">
			<ePixmap pixmap="skin_default/buttons/red.png" position="0,0" size="200,40" scale="stretch" alphatest="on" />
			<ePixmap pixmap="skin_default/buttons/green.png" position="200,0" size="200,40" scale="stretch" alphatest="on" />
			<ePixmap pixmap="skin_default/buttons/yellow.png" position="400,0" size="200,40" scale="stretch" alphatest="on" />
			<ePixmap pixmap="skin_default/buttons/blue.png" position="600,0" size="200,40" scale="stretch" alphatest="on" />
			<widget source="key_red" render="Label" position="0,0" zPosition="1" size="200,40" font="Regular;22" halign="center" valign="center" backgroundColor="#9f1313" transparent="1" />
			<widget source="key_green" render="Label" position="200,0" zPosition="1" size="200,40" font="Regular;22" halign="center" valign="center" backgroundColor="#1f771f" transparent="1" />
			<widget source="key_yellow" render="Label" position="400,0" zPosition="1" size="200,40" font="Regular;22" halign="center" valign="center" backgroundColor="#a08500" transparent="1" />
			<widget source="key_blue" render="Label" position="600,0" zPosition="1" size="200,40" font="Regular;22" halign="center" valign="center" backgroundColor="#18188b" transparent="1" />
			<widget name="text1" font="Regular; 30" foregroundColor="#000996f1" position="30,80" size="900,100"  transparent="1" zPosition="1" />
			<widget name="text2" font="Regular; 28" foregroundColor="#000996f1" position="30,200" size="1200,400"  transparent="1" zPosition="1" />
		</screen>"""
	elif sz_w == 2560:
		# WQHD
		skin = """
		<screen name="TestPluginScreen" position="center,200" size="1600,1000">
			<ePixmap pixmap="skin_default/buttons/red.png" position="0,0" size="400,80" scale="stretch" alphatest="on" />
			<ePixmap pixmap="skin_default/buttons/green.png" position="400,0" size="400,80" scale="stretch" alphatest="on" />
			<ePixmap pixmap="skin_default/buttons/yellow.png" position="800,0" size="400,80" scale="stretch" alphatest="on" />
			<ePixmap pixmap="skin_default/buttons/blue.png" position="1200,0" size="400,80" scale="stretch" alphatest="on" />
			<widget source="key_red" render="Label" position="0,0" zPosition="1" size="400,80" font="Regular;44" halign="center" valign="center" backgroundColor="#9f1313" transparent="1" />
			<widget source="key_green" render="Label" position="400,0" zPosition="1" size="400,80" font="Regular;44" halign="center" valign="center" backgroundColor="#1f771f" transparent="1" />
			<widget source="key_yellow" render="Label" position="800,0" zPosition="1" size="400,80" font="Regular;44" halign="center" valign="center" backgroundColor="#a08500" transparent="1" />
			<widget source="key_blue" render="Label" position="1200,0" zPosition="1" size="400,80" font="Regular;44" halign="center" valign="center" backgroundColor="#18188b" transparent="1" />
			<ePixmap pixmap="skin_default/div-h.png" position="0,862" zPosition="2" size="1600,4" />
			<widget name="text1" font="Regular; 35" foregroundColor="#000996f1" position="30,150" size="900,100"  transparent="1" zPosition="1" />
			<widget name="text2" font="Regular; 35" foregroundColor="#000996f1" position="30,250" size="1400,600"  transparent="1" zPosition="1" />
		</screen>"""
	else:
		# HD 1280×720
		skin = """
		<screen name="TestPluginScreen" position="center,100" size="800,500">
			<ePixmap pixmap="skin_default/buttons/red.png" position="0,0" size="200,40" scale="stretch" alphatest="on" />
			<ePixmap pixmap="skin_default/buttons/green.png" position="200,0" size="200,40" scale="stretch" alphatest="on" />
			<ePixmap pixmap="skin_default/buttons/yellow.png" position="400,0" size="200,40" scale="stretch" alphatest="on" />
			<ePixmap pixmap="skin_default/buttons/blue.png" position="600,0" size="200,40" scale="stretch" alphatest="on" />
			<widget source="key_red" render="Label" position="0,0" zPosition="1" size="200,40" font="Regular;22" halign="center" valign="center" backgroundColor="#9f1313" transparent="1" />
			<widget source="key_green" render="Label" position="200,0" zPosition="1" size="200,40" font="Regular;22" halign="center" valign="center" backgroundColor="#1f771f" transparent="1" />
			<widget source="key_yellow" render="Label" position="400,0" zPosition="1" size="200,40" font="Regular;22" halign="center" valign="center" backgroundColor="#a08500" transparent="1" />
			<widget source="key_blue" render="Label" position="600,0" zPosition="1" size="200,40" font="Regular;22" halign="center" valign="center" backgroundColor="#18188b" transparent="1" />
			<ePixmap pixmap="skin_default/div-h.png" position="0,431" zPosition="2" size="800,2" />
			<widget name="text1" font="Regular; 20" foregroundColor="#000996f1" position="30,50" size="750,100"  transparent="1" zPosition="1" />
			<widget name="text2" font="Regular; 20" foregroundColor="#000996f1" position="30,100" size="750,400"  transparent="1" zPosition="1" />
		</screen>"""
		
	def __init__(self, session):
		Screen.__init__(self, session)
		
		self.setTitle("TEST-Plugin - check NN2-Feed")
		
		self["text1"] = Label("zum Ausühren die OK-Taste drücken")
		self["text2"] = Label("")
		
		# Initialize widgets
		self["key_red"] = StaticText(_("Cancel"))
		self["key_green"] = StaticText(_("green"))
		self["key_yellow"] = StaticText("yellow")
		self["key_blue"] = StaticText("blue")
		
		# Define Actions
		self["actions"] = ActionMap(["SetupActions", "ColorActions","MediaPlayerActions"],
			{
				"cancel": 	self.close,
				"ok":		self.start_check,
			},-2)

	def start_check(self):
		
		self.timer = eTimer()
		self.timer_conn = self.timer.timeout.connect(self.check_old)
		
		print("========= start test - %s - =========\n" % time.strftime("%H:%M:%S", time.localtime(time.time())))
		self.check_text = "========= start test - %s - =========\n" % time.strftime("%H:%M:%S", time.localtime(time.time()))
		self["text2"].setText(self.check_text)
		
		self.timer.start(50,True)
		
	def check_old(self):
		try:
			
			#current code in updatecheck.py to check feed-url
			starttime = time.time()
			self.con = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
			self.con.settimeout(2)
			try:
				self.con.connect(("feed.newnigma2.to", 80))
				self.con.close()
				self.online = True
			except socket.error as msg:
				self.con.close()
				self.online = False
			print("=== check url socket connect: %s - %.3fs - current Code" % (self.online, time.time() - starttime))
			self.check_text += "=== check url socket connect: %s - %.3fs - current Code\n" % (self.online, (time.time() - starttime))
			self["text2"].setText(self.check_text)
			
			self.timer_conn = self.timer.timeout.connect(self.check_new)
			self.timer.start(50,True)
		
		except:
			import traceback, sys
			traceback.print_exc()

	def check_new(self):
		try:
			#new code to check feed-url
			try:
				starttime = time.time()
				r = requests.get('https://feed.newnigma2.to', timeout=2, verify=False)
				self.online = r.status_code == 200
			except requests.exceptions.RequestException as e:
				print("=== error", e)
				self.online = False
				self.check_text += "=== error %s\n" % e
			print("=== check url get status NN2-feed: %s - %.3fs - new Code" % (self.online, time.time() - starttime))
			self.check_text += "=== check url get status NN2-feed: %s - %.3fs - new Code\n" % (self.online, time.time() - starttime)
			self["text2"].setText(self.check_text)
			
			self.timer_conn = self.timer.timeout.connect(self.check_google)
			self.timer.start(50,True)
			
		except:
			import traceback, sys
			traceback.print_exc()

	def check_google(self):
		try:
			#new code to check google url
			try:
				starttime = time.time()
				r = requests.get('https://google.de', timeout=2, verify=False)
				self.online = r.status_code == 200
			except requests.exceptions.RequestException as e:
				self.online = False
			print("=== check url get status google: %s - %.3fs - new Code check google url" % (self.online, time.time() - starttime))
			self.check_text += "=== check url get status google: %s - %.3fs - new Code check google url\n" % (self.online, time.time() - starttime)
			
			self.check_text += "========= ende test ========="
			self["text2"].setText(self.check_text)
			
			print("========= ende test =========")
			
		except:
			import traceback, sys
			traceback.print_exc()

