# /usr/lib/enigma2/python/Plugins/newnigma2/paketmanager/Paketmanager.py
from Screens.Screen import Screen
from Screens.VirtualKeyBoard import VirtualKeyBoard
from Screens.HelpMenu import HelpMenu
from Screens.InputBox import InputBox
from Screens.ChoiceBox import ChoiceBox
from Screens.MessageBox import MessageBox
from Components.MultiContent import MultiContentEntryText, MultiContentEntryPixmapAlphaTest
from Components.config import config, configfile, getConfigListEntry
from Components.Sources.StaticText import StaticText
from Components.Sources.List import List
from Components.ActionMap import ActionMap, NumberActionMap, HelpableActionMap
from Components.ConfigList import ConfigListScreen
from Components.Pixmap import Pixmap
from Tools.LoadPixmap import LoadPixmap
from Components.AVSwitch import AVSwitch
from Components.Label import Label
from Components.Button import Button
from Components.MenuList import MenuList
from Components.Harddisk import harddiskmanager
from Plugins.newnigma2.tools.NewNigma2Stuff import __, nPrint, getPng
from Tools.HardwareInfo import HardwareInfo
from enigma import getDesktop
from enigma import eConsoleAppContainer, eListboxPythonMultiContent, gFont, loadPNG, eTimer, ePicLoad, ePixmap, loadJPG, gPixmapPtr, ePoint, iServiceInformation
from ServiceReference import ServiceReference
from operator import itemgetter, attrgetter, methodcaller
import subprocess, os, time, hashlib, string
from Screens.Standby import TryQuitMainloop
from Plugins.SystemPlugins.SkinSelector.plugin import SkinSelector
from Plugins.newnigma2.camdctrl.camdctrl import CamdWizzardScreen
from apt.cache import FetchFailedException, FetchCancelledException
import apt, apt_pkg, apt.debfile, apt.progress, requests
from Plugins.newnigma2.tools import libc
RESCUEMD5 = '732953905723455c326d3f90466e1eee'
Version = '08-09-2025'

class FBLCDScreen(Screen):
    skin = ('<screen name="FBLCDScreen" position="0,0" size="132,64" id="1">\n\t\t<widget name="text1" position="2,1" size="128,18" halign="center" font="Display;16"/>\n\t\t<eLabel backgroundColor="white" position="0,19" size="132,1" />\n\t\t<widget name="text2" position="2,21" size="128,14" font="Display;12"/>\n\t\t<widget name="text3" position="2,36" size="128,14" font="Display;12"/>\n\t\t<widget name="text4" position="2,50" size="128,14" font="Display;12"/>\n\t</screen>', '<screen name="FBLCDScreen" position="0,0" size="400,240" id="3">\n\t\t<widget name="text1" position="5,1"   size="395,50" halign="center" foregroundColor="#000055ff" font="Display;50"/>\n\t\t<widget name="text2" position="5,52"  size="385,40" halign="center" foregroundColor="#000055ff" font="Display;40"/>\n\t\t<widget name="text3" position="5,138" size="385,30" halign="center" foregroundColor="#00a2ef2c" font="Display;30"/>\n\t\t<widget name="text4" position="5,189" size="385,50" halign="center" foregroundColor="#00e5b243" font="Display;50"/>\n\t</screen>')

    def __init__(self, session, parent):
        Screen.__init__(self, session)
        self['text1'] = Label('PAKETMANAGER')
        self['text2'] = Label('NEWNIGMA2')
        self['text3'] = Label('')
        self['text4'] = Label('')

    def setText(self, text, line):
        if line == 1:
            self['text1'].setText(text)
        if line == 2:
            self['text2'].setText(text)
        elif line == 3:
            self['text3'].setText(text)
        elif line == 4:
            self['text4'].setText(text)

from os import path as os_path
def getBoxArch():
	boxtype="dreamone"
	if os_path.exists("/proc/stb/info/model"):
		f=open("/proc/stb/info/model")
		boxtype=f.read()
		f.close()
		boxtype=boxtype.replace("\n","").replace("\l","")
	if boxtype == "dm525":
		boxtype="dm520"
	if boxtype == "one":
		boxtype="dreamone"
	if boxtype == "two":
		boxtype="dreamtwo"
	arch="arm64"
	if boxtype=="dm900" or boxtype=="dm920":
		arch="armhf"
	if boxtype=="dm7080" or boxtype=="dm820" or boxtype=="dm520":
		arch="mipsel"
	return arch

boxArch = getBoxArch()

class PKGMain(Screen):
    skin = '\n\t<screen name="PKGMain" position="center,50" size="1200,720" title="Paketmanager" >\n\t\t<ePixmap name="red" position="10,620" size="200,40" pixmap="/usr/lib/enigma2/python/Plugins/newnigma2/paketmanager/icons/red.png" alphatest="on" />\n\t\t<ePixmap name="yellow" position="670,620"  size="200,40" pixmap="/usr/lib/enigma2/python/Plugins/newnigma2/paketmanager/icons/yellow.png" alphatest="on" />\n\t\t<ePixmap name="blue"   position="1000,620" size="200,40" pixmap="/usr/lib/enigma2/python/Plugins/newnigma2/paketmanager/icons/blue.png"   alphatest="on" />\n\t\t<ePixmap name="green" position="340,620" size="200,40" pixmap="/usr/lib/enigma2/python/Plugins/newnigma2/paketmanager/icons/green.png" alphatest="on" />\n\t\t<ePixmap position="1120,0" size="70,30" pixmap="/usr/lib/enigma2/python/Plugins/newnigma2/paketmanager/icons/menu.png" alphatest="blend" />\n\t\t<widget source="key_red" render="Label" position="10,620" zPosition="1" size="200,40" font="Regular;20" halign="center" valign="center" backgroundColor="#9f1313" transparent="1" />\n\t\t<widget source="key_green" render="Label" position="340,620" zPosition="1" size="200,40" font="Regular;20" halign="center" valign="center" backgroundColor="#1f771f" transparent="1" />\n\t\t<widget source="key_yellow" render="Label" position="670,620" zPosition="1" size="200,40" font="Regular;20" halign="center" valign="center" backgroundColor="#a08500" transparent="1" />\n\t\t<widget source="key_blue" render="Label" position="1000,620" zPosition="1" size="200,40" font="Regular;20" halign="center" valign="center" backgroundColor="#18188b" transparent="1" />\n\t\t<widget name="pkginfo" position="10,440" size="1180,150" zPosition="2" font="Regular;18" halign="center" transparent="1" />\n\t\t<widget source="pkg" render="Listbox" position="10,30" size="1180,400" zPosition="1" scrollbarMode="showOnDemand" enableWrapAround="1">\n\t\t\t<convert type="TemplatedMultiContent">\n\t\t\t\t{"template": [\n\t\t\t\t\t\tMultiContentEntryPixmapAlphaTest(pos=(1,17), size=(15,16), png=1),        #png\n\t\t\t\t\t\tMultiContentEntryText(pos=(20,1),     size=(1000,25), font=1, text=2),    #paket\n\t\t\t\t\t\tMultiContentEntryText(pos=(20,26),    size=(200,20),  font=0, text=3),    #version\n\t\t\t\t\t\tMultiContentEntryText(pos=(1050,26),  size=(150,20),  font=0, text=4),    #size\n\t\t\t\t\t\tMultiContentEntryText(pos=(800,26),   size=(250,20),  font=0, text=5),    #section\n\t\t\t\t\t\tMultiContentEntryText(pos=(1010,6),   size=(190,20),  font=0, text=6),    #updateable\n\t\t\t\t\t],\n\t\t\t\t"fonts": [gFont("Regular", 15),gFont("Regular", 20)],\n\t\t\t\t"itemHeight": 50\n\t\t\t\t}\n\t\t\t</convert>\n\t\t</widget>\n\t</screen>'

    def __init__(self, session, plugin_path):
        self.plugin_path = plugin_path
        self.skin_path = plugin_path
        self.session = session
        self.message = __('Please Wait....')
        self.aptready = False
        Screen.__init__(self, session)

        self.menu = []
        self.menu.append((None,
         None,
         self.message,
         None,
         None,
         None,
         None))
        self['pkginfo'] = Label()
        self['key_blue'] = StaticText(__('Dist Upgrade'))
        self['key_green'] = StaticText(__('Offline Install'))
        self['key_red'] = StaticText(__('Exit'))
        self['key_yellow'] = StaticText(__('Filter'))
        self['key_menu'] = StaticText(__('Autoremove'))
        self['pkg'] = List([])
        self['pkg'].setList(self.menu)
        self['actions'] = ActionMap(['OkCancelActions',
         'TeleTextActions',
         'EPGSelectActions',
         'DirectionActions',
         'ColorActions',
         'MenuActions',
         'NumberActions',
         'HelpActions',
         'InfobarActions',
         'MediaPlayerActions'], {'ok': self.okClick,
         'cancel': self.cancelClick,
         'red': self.cancelClick,
         'green': self.Offline,
         'blue': self.upgradepush,
         'yellow': self.aptfilter,
         'info': self.autoremovepush,
         'left': self.keyLeft,
         'right': self.keyRight,
         'up': self.keyUp,
         'menu': self.autoremovepush,
         'down': self.keyDown,
         'upRepeated': self.keyUp,
         'downRepeated': self.keyDown,
         'rightRepeated': self.keyRight,
         'leftRepeated': self.keyLeft,
         '5': self.rescuepush,
         '6': self.maintenancepush,
         'help': self.Help,
         '7': self.backup}, -2)
        self['actions'].setEnabled(True)
        self.helpList.append((self['actions'], 'OkCancelActions', [('cancel', __('Exit'))]))
        self.helpList.append((self['actions'], 'OkCancelActions', [('ok', __('Ok'))]))
        self.helpList.append((self['actions'], 'TeleTextActions', [('red', __('Exit'))]))
        self.helpList.append((self['actions'], 'TeleTextActions', [('green', __('Offline Install'))]))
        self.helpList.append((self['actions'], 'TeleTextActions', [('yellow', __('Package Filter'))]))
        self.helpList.append((self['actions'], 'TeleTextActions', [('blue', __('Upgrade'))]))
        self.helpList.append((self['actions'], 'TeleTextActions', [('5', __('Rescue Upgrade'))]))
        self.helpList.append((self['actions'], 'TeleTextActions', [('6', __('Maintenance'))]))
        self.helpList.append((self['actions'], 'TeleTextActions', [('7', __('Backup'))]))
        self.helpList.append((self['actions'], 'TeleTextActions', [('menu', __('Autoremove'))]))
        self.timer = eTimer()
        self.box = HardwareInfo().get_device_name()
        self.green = getPng(self.plugin_path, 'minigreen.png')
        self.blue = getPng(self.plugin_path, 'miniblue.png')
        print '[Paketmanager] ', Version
        #if self.aptready:
        self.onLayoutFinish.append(self.layoutFinished)
        self.working = False
        return

    def Help(self):
        self.session.open(HelpMenu, self.helpList)

    def createSummary(self):
        return FBLCDScreen

    def keyUp(self):
        self['pkg'].moveSelection('moveUp')
        self.getdescription()

    def keyDown(self):
        self['pkg'].moveSelection('moveDown')
        self.getdescription()

    def keyLeft(self):
        self['pkg'].moveSelection('pageUp')
        self.getdescription()

    def keyRight(self):
        self['pkg'].moveSelection('pageDown')
        self.getdescription()

    def aptfilter(self):
        if self.online and not self.timer.isActive():
            self.working = True
            config.plugins.paketmanager.ActivateFilter.value = True
            self.session.openWithCallback(self.workFinished, AptFilter, self.plugin_path)
        elif not self.online:
            nPrint('[Paketmanager] skip aptfilter - feed not available')
            return False
        else:
            nPrint('[Paketmanager] skip aptfilter - timer.isActive')

    def okClick(self):
        if self['pkg'].getCurrent() is not None:
            self.package = self['pkg'].getCurrent()[2]
            self.installed = self['pkg'].getCurrent()[0]
            self.upgradeable = self['pkg'].getCurrent()[6]
            if not self.timer.isActive():
                if self.package is not None:
                    if self.installed:
                        nPrint(self.package + ' is_installed')
                        if self.upgradeable:
                            message = __('Update this Package?  %s') % self.package
                            self.session.openWithCallback(self.singleupdate, MessageBox, message, type=MessageBox.TYPE_YESNO, timeout=20, default=False)
                        message = __('Do you really want to uninstall the Package? %s') % self.package
                        self.session.openWithCallback(self.deinstall, MessageBox, message, type=MessageBox.TYPE_YESNO, timeout=20, default=False)
                    if not self.installed:
                        nPrint(self.package + ' is_not_installed')
                        message = __('Do you really want to install the package? %s') % self.package
                        self.session.openWithCallback(self.install, MessageBox, message, type=MessageBox.TYPE_YESNO, timeout=20, default=False)
        return

    def install(self, confirmed):
        if confirmed:
            if self['pkg'].getCurrent() is not None:
                self.package = self['pkg'].getCurrent()[2]
                self.popup(1, self.package, None)
                self.working = True
        return

    def reinstallpush(self):
        message = __('Reinstall the package? %s') % self.package
        self.session.openWithCallback(self.reinstall, MessageBox, message, type=MessageBox.TYPE_YESNO, timeout=20, default=False)

    def reinstall(self, confirmed):
        if confirmed:
            if self['pkg'].getCurrent() is not None:
                self.package = self['pkg'].getCurrent()[2]
                self.installed = self['pkg'].getCurrent()[0]
                if self.installed:
                    self.popup(6, self.package, None)
                    self.working = True
        return

    def backup(self):
        if os.path.isfile(self.plugin_path + '/dmbackup'):
            self.popup(8, None, None)
            self.working = True
        return

    def upgradepush(self):
        if self.online and not self.timer.isActive():
            message = __('Do you really want to Upgrade?')
            self.session.openWithCallback(self.upgrade, MessageBox, message, type=MessageBox.TYPE_YESNO, timeout=20, default=False)
        elif not self.online:
             nPrint('[Paketmanager] skip aptfilter - nn2-feed not available')
             return False

    def autoremovepush(self):
        if not self.timer.isActive():
            message = __('Remove unneeded packages?')
            self.session.openWithCallback(self.autoremove, MessageBox, message, type=MessageBox.TYPE_YESNO, timeout=20, default=False)

    def rescuepush(self):
        if not self.timer.isActive():
            message = __('Flash Rescue Image?\nIt can take several minutes and can not be canceled!!')
            self.session.openWithCallback(self.RescueUpdate, MessageBox, message, type=MessageBox.TYPE_YESNO, timeout=20, default=False)

    def maintenancepush(self):
        if not self.timer.isActive():
            message = __('Start Maintenance?')
            self.session.openWithCallback(self.maintenance, MessageBox, message, type=MessageBox.TYPE_YESNO, timeout=20, default=False)

    def autoremove(self, confirmed):
        if confirmed:
            self.popup(4, None, None)
            self.MenuUpdate()
            self.working = True
        return

    def RescueUpdate(self, confirmed):
        if confirmed:
            self.popup(7, None, None)
            self.working = True
        return

    def upgrade(self, confirmed):
        if confirmed:
            self.popup(3, None, None)
            self.working = True
        return

    def maintenance(self, confirmed):
        if confirmed:
            self.popup(9, None, None)
            self.working = True
        return

    def singleupdate(self, confirmed):
        if confirmed:
            if self['pkg'].getCurrent() is not None:
                self.package = self['pkg'].getCurrent()[2]
            self.popup(5, self.package, None)
            self.Package.update()
            self.Package.open(None)
            self.MenuUpdate()
            self.working = True
        return

    def deinstall(self, confirmed):
        if confirmed:
            if self['pkg'].getCurrent() is not None:
                self.package = self['pkg'].getCurrent()[2]
                self.popup(2, self.package, None)
                self.MenuUpdate()
                self.working = True
        return

    def getpackages(self, filter):
        self.packages = []
        self.FilterList = self.getfilter()
        showUpdates = config.plugins.paketmanager.ShowUpdates.value
        try:
            #for pkg in self.cache.packages:
            print('[Paketmanager] getpackages - filter, FilterList, showUpdates', filter, self.FilterList, showUpdates)
            for pkg in self.Package._cache.packages:
                if pkg.architecture != boxArch:
                    #nPrint('[Paketmanager] skip package for wrong arch: %s, %s, %s' % (pkg.architecture, boxArch, pkg.name))
                    continue # skip feed-packages for other boxArch
                if filter:
                    for app in self.FilterList:
                        if pkg.name.find(app) != -1:
                            try:
                                self.pkgvar = self.Package[pkg.name]
                                if showUpdates and not self.pkgvar.is_upgradable:
                                    continue
                                if self.pkgvar.is_installed:
                                    self.packages.append((pkg.name, True))
                                else:
                                    self.packages.append((pkg.name, False))
                            except KeyError:
                                continue

                else:
                    try:
                        if not self.Package.is_virtual_package(pkg.name):
                            self.pkgvar = self.Package[pkg.name]
                            if showUpdates and not self.pkgvar.is_upgradable:
                                continue
                            if self.pkgvar.is_installed:
                                self.packages.append((pkg.name, True))
                            else:
                                self.packages.append((pkg.name, False))
                        else:
                            pass
                            #nPrint('[Paketmanager] skip package is_virtual arch: %s, %s, %s' % (pkg.architecture, boxArch, pkg.name))
                    except KeyError as e:
                        #nPrint('[Paketmanager] getpackages - error: %s, packageName: %s' % (e,pkg.name))
                        continue

            nPrint('[Paketmanager] getpackages - filter: %s, count: %s' % (filter,len(self.packages)))
            if len(self.packages) > 0:
                self.filtersorted = sorted(self.packages, key=itemgetter(0))
                return self.filtersorted
            return []
        except (AttributeError,
         IOError,
         OSError,
         KeyError,
         TypeError) as e:
            nPrint(str(e))
            return None

        return None

    def getdescription(self):
        message = ''
        try:
            if self['pkg'].getCurrent() is not None:
                self.package = self['pkg'].getCurrent()[2]
                self.section = self['pkg'].getCurrent()[5]
                self.pkg = self.Package[self.package]
                #self.desc = str(self.pkg.candidate.description)
                self.desc = str(self.pkg.candidate._translated_records.long_desc)
                self.desc_lines = self.desc.split("\n")
                if len(self.desc_lines) >1 and self.desc_lines[0] in self.desc_lines[1]:
                    self.desc = " ".join(self.desc_lines[1:])
                self.depends = self.getDepends(self.package)
                if len(self.depends) > 0:
                    self.desc += '\nDepends: ' + self.depends
                nPrint('[Paketmanager] Description: ' + str(self.desc) + '\n')
                self['pkginfo'].setText(str(self.desc))
                self.summaries.setText(self.package, 3)
                self.summaries.setText(self.section, 4)
            else:
                self['pkginfo'].setText("")
                self.summaries.setText("", 3)
                self.summaries.setText("", 4)
        except (AttributeError,
         IOError,
         OSError,
         KeyError,
         TypeError) as e:
            nPrint(str(e))
            self['pkginfo'].setText(str(e))

        return

    def getpackagedata(self, package):
        try:
            self.pkg = self.Package[package[0]]
            if package[1]:
                return (int(self.pkg.candidate.size) / 1024,
                 self.pkg.installed.version,
                 self.pkg.section,
                 self.pkg.is_upgradable)
            return (int(self.pkg.candidate.size) / 1024,
             self.pkg.candidate.version,
             self.pkg.section,
             False)
        except (AttributeError,
         IOError,
         OSError,
         KeyError,
         TypeError) as e:
            nPrint(str(e))
            return (0,
             None,
             None,
             False)

        return None

    def MenuUpdate(self):
        nPrint('[Paketmanager] MenuUpdate')
        self.menu = []
        if self.PackageCache is not None:
            for deb in self.PackageCache:
                self.updateavailable = ''
                self.data = self.getpackagedata(deb)
                if self.data[3]:
                    self.updateavailable = __('Updateable')
                self.packagename = deb[0]
                if deb[1]:
                    self.menu.append((True,
                     self.green,
                     self.packagename,
                     self.data[1],
                     str(self.data[0]) + 'kb',
                     self.data[2],
                     self.updateavailable))
                else:
                    self.menu.append((False,
                     self.blue,
                     self.packagename,
                     self.data[1],
                     str(self.data[0]) + 'kb',
                     self.data[2],
                     None))

            self['pkg'].setList(self.menu)
            if self.timer.isActive():
                self.timer.stop()
            self.getdescription()
        return

    def getfilter(self):
        self.exception = []
        if config.plugins.paketmanager.ActivateFilter.value:
            if config.plugins.paketmanager.ShowPlugins.value:
                self.exception.append('enigma2-plugin-')
            if config.plugins.paketmanager.ShowSkins.value:
                self.exception.append('enigma2-skin-')
            if config.plugins.paketmanager.ShowKernel.value:
                self.exception.append('kernel-')
            if config.plugins.paketmanager.ShowCamd.value:
                self.exception.append('newnigma2-camd-')
            if config.plugins.paketmanager.ShowDreambox.value:
                self.exception.append('dreambox-')
            if config.plugins.paketmanager.ShowPython.value:
                self.exception.append('python-')
            if config.plugins.paketmanager.ShowUser.value:
                self.exception.append(config.plugins.paketmanager.User.value)
        return self.exception

    def cancelClick(self):
        if self.timer.isActive():
            self.timer.stop()
        self.close()

    def popup(self, typ, pkg, message):
        self.session.openWithCallback(self.Marked, InstallLog, typ, pkg, message, self.plugin_path)

    def Offline(self):
        self.session.openWithCallback(self.workFinished, OfflineInstall, self.plugin_path)

    def Marked(self, callback = None):
        nPrint('[Paketmanager] marked')
        if self.working:
            self.working = False
            self.index = self['pkg'].getIndex()
            if self['pkg'].getCurrent() is not None:
                self.deb = self['pkg'].getCurrent()[2]
            nPrint('[Paketmanager] marked - Package.update')
            self.Package.update()
            self.Package.open(None)
            if config.plugins.paketmanager.ActivateFilter.value:
                self.PackageCache = self.getpackages(True)
            else:
                self.PackageCache = self.getpackages(False)
                config.plugins.paketmanager.ActivateFilter.value = False
            self.MenuUpdate()
        return

    def getDepends(self, Package):
        self.depends = ''
        try:
            self.pkg = self.Package[Package]
            for self.dep in self.pkg.candidate.dependencies:
                for item in self.dep.or_dependencies:
                    if len(item.version) > 0:
                        self.depends += item.name + '(' + item.version + ') '
                    else:
                        self.depends += item.name + ' '

        except (AttributeError,
         IOError,
         OSError,
         KeyError,
         TypeError) as e:
            nPrint(str(e))

        return self.depends

    def workFinished(self, callback = None):
        if self.working:
            self.message = __('Please Wait....')
            self.menu = []
            self.menu.append((None, None, self.message, None, None, None, None))
            self['pkg'].setList(self.menu)
            self.working = False
            if self.getfilter():
                nPrint('[Paketmanager] workFinished - get filter packages')
                config.plugins.paketmanager.ActivateFilter.value = True
                self.PackageCache = self.getpackages(True)
            else:
                nPrint('[Paketmanager] workFinished - get all packages')
                config.plugins.paketmanager.ActivateFilter.value = False
                self.PackageCache = self.getpackages(False)
            self.timer.start(500, True)
        else:
            nPrint('[Paketmanager] workFinished - not self.working')

    def layoutFinished(self):
        self.setTitle('Newnigma2 Paketmanager ' + Version)
        self.timer_conn = self.timer.timeout.connect(self.callMenuUpdate)
        nPrint('[Paketmanager] layoutFinished - start callMenuUpdate')
        self.timer.start(50, True)
    
    def callMenuUpdate(self):
        self.timer_conn = self.timer.timeout.connect(self.MenuUpdate)
        try:
            #online-check for nn2-feed
            try:
                r = requests.get('https://feed.newnigma2.to', timeout=3, verify=False)
                self.online = r.status_code == 200
            except requests.exceptions.RequestException as e:
                self.online = False
            
            if not self.online:
                self.message = 'the nn2-feed is currently unavailable - try again later' 
                self.aptready = False
                self.menu = []
                self.menu.append((None, None, self.message, None, None, None, None))
                self['pkg'].setList(self.menu)
                nPrint('[Paketmanager] callMenuUpdate - nn2-feed is currently unavailable')
                return
            else:
                nPrint('[Paketmanager] callMenuUpdate - nn2-feed is online')
            
            #self.apt_pkg = apt_pkg
            #self.apt_pkg.init_config()
            #self.apt_pkg.init_system()
            #self.cache = self.apt_pkg.Cache()
            
            self.Package = apt.Cache()
            nPrint('[Paketmanager] callMenuUpdate - Package.update')
            self.Package.update()
            self.Package.open(None)
            
            if not config.plugins.paketmanager.ActivateFilter.value:
                nPrint('[Paketmanager] callMenuUpdate - get all packages')
                self.PackageCache = self.getpackages(False)
            if config.plugins.paketmanager.ActivateFilter.value:
                nPrint('[Paketmanager] callMenuUpdate - get filter packages')
                self.PackageCache = self.getpackages(True)
            self.aptready = True
        except (FetchCancelledException, FetchFailedException, AttributeError, IOError, OSError, KeyError, TypeError) as e:
            nPrint(str(e))
            self.message = '%s' % str(e)
            self.aptready = False
            self.menu = []
            self.menu.append((None, None, self.message, None, None, None, None))
            self['pkg'].setList(self.menu)
        
        if self.aptready:
            self.timer_conn = self.timer.timeout.connect(self.MenuUpdate)
            nPrint('[Paketmanager] callMenuUpdate - start MenuUpdate')
            self.timer.start(500, True)


class AptFilter(Screen, ConfigListScreen):
    skin = '\n\t\t<screen name="AptFilter" position="center,300" size="950,550" title="Filter" >\n\t\t\t<widget name="config" position="10,10" size="930,530" scrollbarMode="showOnDemand" enableWrapAround="1" />\n\t\t\t<widget name="HelpWindow" pixmap="skin_default/vkey_icon.png" position="340,730" zPosition="1" size="1,1" transparent="1" alphatest="on" /> \n\t\t</screen>'

    def __init__(self, session, plugin_path):
        Screen.__init__(self, session)
        self.plugin_path = plugin_path
        self.skin_path = plugin_path
        self.onChangedEntry = []
        self.list = []
        ConfigListScreen.__init__(self, self.list, session=session, on_change=self.changedEntry)
        self['actions'] = ActionMap(['OkCancelActions',
         'NumberActions',
         'ColorActions',
         'InputActions',
         'MenuActions'], {'ok': self.keySave,
         'cancel': self.cancelClick}, -2)
        self['HelpWindow'] = Pixmap()
        self.configlist()
        self.onLayoutFinish.append(self.layoutFinished)

    def cancelClick(self):
        self.close(False)

    def configlist(self):
        self.list = []
        self.list.append(getConfigListEntry(__('Show Updates:'), config.plugins.paketmanager.ShowUpdates, 2))
        self.list.append(getConfigListEntry(__('Show Plugins:'), config.plugins.paketmanager.ShowPlugins, 2))
        self.list.append(getConfigListEntry(__('Show Skins:'), config.plugins.paketmanager.ShowSkins, 2))
        self.list.append(getConfigListEntry(__('Show Kernel:'), config.plugins.paketmanager.ShowKernel, 2))
        self.list.append(getConfigListEntry(__('Show Camd:'), config.plugins.paketmanager.ShowCamd, 2))
        self.list.append(getConfigListEntry(__('Show Dreambox:'), config.plugins.paketmanager.ShowDreambox, 2))
        self.list.append(getConfigListEntry(__('Show Python:'), config.plugins.paketmanager.ShowPython, 2))
        self.list.append(getConfigListEntry(__('Show User Defined:'), config.plugins.paketmanager.ShowUser, 2))
        self.list.append(getConfigListEntry(__('User Defined:'), config.plugins.paketmanager.User, 1))
        self.list.append(getConfigListEntry(__('Shortcut Skins:'), config.plugins.paketmanager.enableSkins, 2))
        self.list.append(getConfigListEntry(__('Shortcut Kernel:'), config.plugins.paketmanager.enableKernel, 2))
        self.list.append(getConfigListEntry(__('Shortcut Plugins:'), config.plugins.paketmanager.enablePlugins, 2))
        self.list.append(getConfigListEntry(__('Shortcut Python:'), config.plugins.paketmanager.enablePython, 2))
        self['config'].list = self.list
        self['config'].l.setList(self.list)
        self['config'].onSelectionChanged.append(self.selectionChanged)

    def selectionChanged(self):
        current = self['config'].getCurrent()
        if current[2] == 1:
            helpwindowpos = self['HelpWindow'].getPosition()
            if current[1].help_window.instance is not None:
                current[1].help_window.instance.move(ePoint(helpwindowpos[0], helpwindowpos[1]))
        return

    def changedEntry(self):
        for x in self.onChangedEntry:
            x()

    def _onKeyChange(self):
        try:
            cur = self['config'].getCurrent()
            if cur and cur[2]:
                self.configlist()
        except:
            pass

    def keySave(self):
        for x in self['config'].list:
            x[1].save()

        configfile.save()
        self.cancelClick()

    def layoutFinished(self):
        self.setTitle('Filter')


class InstallLog(Screen):
    skin = '\n\t<screen name="InstallLog" position="center,50" size="1200,720" title="Apt" >\n\t\t<ePixmap name="red" position="10,620" size="200,40" pixmap="/usr/lib/enigma2/python/Plugins/newnigma2/paketmanager/icons/red.png" alphatest="on" />\n\t\t<ePixmap name="yellow" position="670,620"  size="200,40" pixmap="/usr/lib/enigma2/python/Plugins/newnigma2/paketmanager/icons/yellow.png" alphatest="on" />\n\t\t<ePixmap name="green" position="340,620" size="200,40" pixmap="/usr/lib/enigma2/python/Plugins/newnigma2/paketmanager/icons/green.png" alphatest="on" />\n\t\t<widget source="key_red" render="Label" position="10,620" zPosition="1" size="200,40" font="Regular;20" halign="center" valign="center" backgroundColor="#9f1313" transparent="1" />\n\t\t<widget source="key_green" render="Label" position="340,620" zPosition="1" size="200,40" font="Regular;20" halign="center" valign="center" backgroundColor="#1f771f" transparent="1" />\n\t\t<widget source="key_yellow" render="Label" position="670,620" zPosition="1" size="200,40" font="Regular;20" halign="center" valign="center" backgroundColor="#a08500" transparent="1" />\n\t\t<widget name="loginfo" position="10,400" size="1260,200" font="Regular;24" halign="center" zPosition="2" transparent="1" foregroundColor="#ffff00"/>\n\t\t<widget source="log" render="Listbox" position="10,40" size="1180,350" scrollbarMode="showOnDemand" zPosition="1" enableWrapAround="1">\n\t\t\t<convert type="TemplatedMultiContent">\n\t\t\t\t{"template": [\n\t\t\t\t\t\tMultiContentEntryText(pos=(1,1),  size=(1160,25), font=2, text=0),\n\t\t\t\t\t],\n\t\t\t\t"fonts": [gFont("Regular", 25),gFont("Regular", 20),gFont("Regular", 16)],\n\t\t\t\t"itemHeight": 25\n\t\t\t\t}\n\t\t\t</convert>\n\t\t</widget>\n\t</screen>'

    def __init__(self, session, typ, package, message, plugin_path):
        self.plugin_path = plugin_path
        self.typ = typ
        self.package = package
        self.message = message
        self.session = session
        Screen.__init__(self, session)
        self['key_red'] = StaticText(__('Exit'))
        self['key_green'] = StaticText(__('Yes'))
        self['key_yellow'] = StaticText(__('No'))
        self['actions'] = ActionMap(['OkCancelActions',
         'EPGSelectActions',
         'DirectionActions',
         'ColorActions',
         'MenuActions',
         'NumberActions',
         'HelpActions',
         'InfobarActions'], {'cancel': self.cancel,
         'red': self.cancel,
         'green': self.executeyes,
         'yellow': self.executeno,
         'blue': self.Magic,
         'exit': self.cancel}, -1)
        self['loginfo'] = Label()
        self['log'] = List([])
        self.xhide = False
        self.writeable = libc.writeable
        self.date = time.strftime
        self.info = None
        self.box = HardwareInfo().get_device_name()
        self.Package = apt.Cache()
        self.Progress = apt.progress.text.AcquireProgress
        self.onLayoutFinish.append(self.layoutFinished)
        self.working = False
        return

    def layoutFinished(self):
        self.setTitle('Newnigma2 Paketmanager')
        self.DataList = []
        self.mylist = []
        self.executecommand = eConsoleAppContainer()
        self.Callback()

    def Callback(self):
        if self.typ == 1:
            if self.checkroot():
                self.install(self.package)
        if self.typ == 2:
            if self.checkroot():
                self.deinstall(self.package)
        if self.typ == 3:
            if self.checkroot():
                self.upgrade()
        if self.typ == 4:
            if self.checkroot():
                self.autoremove()
        if self.typ == 5:
            if self.checkroot():
                self.update(self.package)
        if self.typ == 6:
            if self.checkroot():
                self.reinstall(self.package)
        if self.typ == 7:
            self.RescueImageUpdate()
        if self.typ == 8:
            self.backup()
        if self.typ == 9:
            self.maintenance()

    def info(self, message):
        self['loginfo'].setText('Message')
        if type(message) == str:
            self.mylist.append((message.strip(), None))
        if type(message) == list:
            for line in message:
                self.mylist.append((line.strip(), None))

        self['log'].setList(self.mylist)
        self['log'].moveSelection('moveEnd')
        return

    def Data(self, data):
        data = data.replace('(', '').replace(')', '').replace('%', '%\n')
        item = data.split('\n')
        for line in item:
            if len(line) > 2:
                self.DataList.append((line, None))
                nPrint(line)
                self['log'].setList(self.DataList)
                self['log'].moveSelection('moveEnd')

        return

    def Return(self, callback):
        if callback != 0:
            nPrint('Paketmanager Failed')
            self['loginfo'].setText(__('Not Successfully'))
        if callback == 0:
            nPrint('Paketmanager Done')
            self['loginfo'].setText(__('Successfully'))
            if self.typ == 1 or self.typ == 2 or self.typ == 5:
                if self.package.find('enigma2-skin') != -1:
                    SkinSelect = self.session.openWithCallback(self.SKinSelector, MessageBox, __('Do you want to select a new skin?'), MessageBox.TYPE_YESNO)
                    SkinSelect.setTitle(__('SkinSelector'))
                if self.package.find('enigma2-plugin') != -1:
                    restartbox = self.session.openWithCallback(self.restartGUI, MessageBox, __('Do you want to Restart now?'), MessageBox.TYPE_YESNO)
                    restartbox.setTitle(__('Enigma2 Restart'))
                if self.package.find('kernel') != -1:
                    rebootbox = self.session.openWithCallback(self.rebootBox, MessageBox, __('Do you want to Reboot now?'), MessageBox.TYPE_YESNO)
                    rebootbox.setTitle(__('Reboot'))
                if self.package.find('newnigma2-camd-') != -1:
                    camd = self.session.openWithCallback(self.CamdSelector, MessageBox, __('Do you want to select a new camd?'), MessageBox.TYPE_YESNO)
                    camd.setTitle(__('CamdSelector'))
            if self.typ == 3:
                restartbox = self.session.openWithCallback(self.restartGUI, MessageBox, __('Do you want to Restart now?'), MessageBox.TYPE_YESNO)
                restartbox.setTitle(__('Enigma2 Restart'))
                rebootbox = self.session.openWithCallback(self.rebootBox, MessageBox, __('Do you want to Reboot now?'), MessageBox.TYPE_YESNO)
                rebootbox.setTitle(__('Reboot %s' % self.box))
            if self.typ == 7:
                rebootbox = self.session.openWithCallback(self.rebootBox, MessageBox, __('Update Rescueimage successfully.Reboot?'), MessageBox.TYPE_YESNO)
                rebootbox.setTitle(__('Reboot %s' % self.box))

    def Magic(self):
        if self.xhide:
            self.instance.show()
            self.xhide = False
        else:
            self.instance.hide()
            self.xhide = True

    def install(self, pkg):
        self['loginfo'].setText('Install ......')
        self.appClosed = self.executecommand.appClosed.connect(self.Return)
        self.dataAvail = self.executecommand.dataAvail.connect(self.Data)
        cmd = 'apt-get -y install ' + pkg + ' && apt-get -y clean'
        self.executecommand.execute(cmd)

    def deinstall(self, pkg):
        self['loginfo'].setText('Deinstall ......')
        self.appClosed = self.executecommand.appClosed.connect(self.Return)
        self.dataAvail = self.executecommand.dataAvail.connect(self.Data)
        cmd = 'apt-get -y remove ' + pkg
        self.executecommand.execute(cmd)

    def upgrade(self):
        self['loginfo'].setText('Upgrade ......')
        self.appClosed = self.executecommand.appClosed.connect(self.Return)
        self.dataAvail = self.executecommand.dataAvail.connect(self.Data)
        cmd = 'apt-get -y dist-upgrade && apt-get -y clean'
        self.executecommand.execute(cmd)

    def autoremove(self):
        self['loginfo'].setText('Autoremove ......')
        self.appClosed = self.executecommand.appClosed.connect(self.Return)
        self.dataAvail = self.executecommand.dataAvail.connect(self.Data)
        cmd = 'apt-get -y autoremove'
        self.executecommand.execute(cmd)

    def update(self, pkg):
        self['loginfo'].setText('Update ......')
        self.appClosed = self.executecommand.appClosed.connect(self.Return)
        self.dataAvail = self.executecommand.dataAvail.connect(self.Data)
        cmd = 'apt-get -y upgrade ' + pkg + ' && apt-get -y clean'
        self.executecommand.execute(cmd)

    def clean(self):
        self['loginfo'].setText('Clean ......')
        self.appClosed = self.executecommand.appClosed.connect(self.Return)
        self.dataAvail = self.executecommand.dataAvail.connect(self.Data)
        cmd = 'apt-get -y clean'
        self.executecommand.execute(cmd)

    def reinstall(self, pkg):
        self['loginfo'].setText('Reinstall ......')
        self.appClosed = self.executecommand.appClosed.connect(self.Return)
        self.dataAvail = self.executecommand.dataAvail.connect(self.Data)
        cmd = 'apt-get -y install --reinstall  ' + pkg
        self.executecommand.execute(cmd)

    def remount(self):
        self['loginfo'].setText('remount ......')
        self.appClosed = self.executecommand.appClosed.connect(self.Return)
        self.dataAvail = self.executecommand.dataAvail.connect(self.Data)
        cmd = 'mount -o remount,rw /'
        self.executecommand.execute(cmd)

    def finstall(self):
        self['loginfo'].setText('Fix ......')
        self.appClosed = self.executecommand.appClosed.connect(self.Return)
        self.dataAvail = self.executecommand.dataAvail.connect(self.Data)
        cmd = 'apt-get -f install'
        self.executecommand.execute(cmd)

    def backup(self):
        self['loginfo'].setText('Backup ......')
        self.appClosed = self.executecommand.appClosed.connect(self.Return)
        self.dataAvail = self.executecommand.dataAvail.connect(self.Data)
        if self.box == 'one' or self.box == 'two':
            cmd = self.plugin_path + '/dmbackup -gz /data'
        else:
            cmd = self.plugin_path + '/dmbackup -gz'
        self.executecommand.execute(cmd)

    def maintenance(self):
        self['loginfo'].setText('Maintenance ......')
        if self.checkroot():
            self.clean()
            self.finstall()
            self['loginfo'].setText('Maintenance done...')

    def executeyes(self):
        cmd = 'yes\n'
        self.executecommand.write(cmd, len(cmd))

    def executeno(self):
        cmd = 'no\n'
        self.executecommand.write(cmd, len(cmd))

    def checkroot(self):
        self.wr = self.writeable('/')
        if self.wr:
            return True
        if not self.wr:
            self.remount()
            self.wr = self.writeable('/')
            return self.wr

    def md5sum(self, filename, blocksize = 65536):
        hash = hashlib.md5()
        with open(filename, 'rb') as f:
            for block in iter(lambda : f.read(blocksize), ''):
                hash.update(block)

        return hash.hexdigest()

    def RescueImageUpdate(self):
        if os.path.isfile('/root/.vip'):
            self.compare = self.md5sum(self.plugin_path + '/RescueUpdate')
            if self.compare == RESCUEMD5:
                self['loginfo'].setText('Rescue Image Flash ......')
                self.appClosed = self.executecommand.appClosed.connect(self.Return)
                self.dataAvail = self.executecommand.dataAvail.connect(self.Data)
                cmd = self.plugin_path + '/RescueUpdate'
                self.executecommand.execute(cmd)

    def restartGUI(self, answer):
        if answer:
            self.session.open(TryQuitMainloop, 3)

    def rebootBox(self, answer):
        if answer:
            self.session.open(TryQuitMainloop, 2)

    def SKinSelector(self, answer):
        if answer:
            self.session.open(SkinSelector)

    def CamdSelector(self, answer):
        if answer:
            self.session.open(CamdWizzardScreen)

    def cancel(self):
        if self.executecommand.running():
            self.executecommand.sendCtrlC()
        self.clean()
        self.close()


class OfflineInstall(Screen):
    skin = '\n\t<screen name="OfflineInstall" position="center,50" size="1200,720" title="Paket Installer" >\n\t\t<ePixmap name="red" position="10,620" size="200,40" pixmap="/usr/lib/enigma2/python/Plugins/newnigma2/paketmanager/icons/red.png" transparent="1" alphatest="on" />\n\t\t<widget source="key_red" render="Label" position="10,620" zPosition="1" size="200,40" valign="center" halign="center" font="Regular;20" backgroundColor="#9f1313" transparent="1" />\n\t\t<widget name="info" position="10,330" size="1180,20" font="Regular;20" halign="left" transparent="1"/>\n\t\t<widget source="list" render="Listbox" position="10,40" size="1180,280" scrollbarMode="showOnDemand" zPosition="1" enableWrapAround="1">\n\t\t\t<convert type="TemplatedMultiContent">\n\t\t\t\t{"template": [\n\t\t\t\t\t\tMultiContentEntryPixmapAlphaTest(pos = (1,2), size = (35,35), png=3),                                        #png\n\t\t\t\t\t\tMultiContentEntryText(pos=(40,8),  size=(800,25), font=1, text=0, flags=RT_HALIGN_LEFT|RT_VALIGN_CENTER),    #paket\n\t\t\t\t\t\tMultiContentEntryText(pos=(850,10), size=(330,20), font=2, text=1, flags=RT_HALIGN_LEFT|RT_VALIGN_CENTER),   #devicename\n\t\t\t\t\t],\n\t\t\t\t"fonts": [gFont("Regular", 25),gFont("Regular", 20),gFont("Regular", 16)],\n\t\t\t\t"itemHeight": 40\n\t\t\t\t}\n\t\t\t</convert>\n\t\t</widget>\n\t\t<widget source="statuslist" render="Listbox" position="10,330" size="1180,250" scrollbarMode="showAlways">\n\t\t\t<convert type="TemplatedMultiContent">\n\t\t\t\t{"template": [\n\t\t\t\t\t\tMultiContentEntryText(pos=(1,1), size=(1179,22), text=0, font=0, flags=RT_HALIGN_LEFT|RT_VALIGN_CENTER),\n\t\t\t\t\t],\n\t\t\t\t"fonts": [gFont("Regular", 20)],\n\t\t\t\t"itemHeight": 25\n\t\t\t\t}\n\t\t\t</convert>\n\t\t</widget>\n\t</screen>'

    def __init__(self, session, plugin_path):
        self.plugin_path = plugin_path
        self.skin_path = plugin_path
        self.session = session
        Screen.__init__(self, session)
        self['key_red'] = StaticText(__('Exit'))
        self['actions'] = ActionMap(['OkCancelActions',
         'EPGSelectActions',
         'DirectionActions',
         'ColorActions',
         'MenuActions',
         'NumberActions',
         'HelpActions',
         'InfobarActions'], {'ok': self.aktion,
         'cancel': self.cancel,
         'red': self.cancel,
         'exit': self.cancel,
         'up': self.keyUp,
         'down': self.keyDown,
         'blue': self.ListChange}, -1)
        self['info'] = Label()
        self.offline = []
        self['list'] = List([])
        self['statuslist'] = List([])
        self['list'].setList(self.offline)
        self.DataList = []
        self.Progress = apt.progress.text.AcquireProgress
        self.Package = apt.Cache()
        self.debfile = apt.debfile.DebPackage
        self.onLayoutFinish.append(self.layoutFinished)
        self.ListSelect = False
        self.working = False

    def ListChange(self):
        if self.ListSelect == False:
            self.ListSelect = True
        else:
            self.ListSelect = False

    def keyUp(self):
        if self.ListSelect == False:
            self['list'].moveSelection('moveUp')
        if self.ListSelect == True:
            self['statuslist'].moveSelection('moveUp')

    def keyDown(self):
        if self.ListSelect == False:
            self['list'].moveSelection('moveDown')
        if self.ListSelect == True:
            self['statuslist'].moveSelection('moveDown')

    def layoutFinished(self):
        mounted = [ (r.mountpoint, r.description) for r in harddiskmanager.getMountedPartitions(onlyhotplug=False) ]
        for part in mounted:
            try:
                for deb in os.listdir(part[0]):
                    if deb.endswith('.deb'):
                        self.offline.append((deb,
                         part[1],
                         part[0],
                         loadPNG(self.plugin_path + '/icons/deb.png')))

            except (SystemError,
             AttributeError,
             IOError,
             OSError,
             KeyError) as e:
                nPrint(e)
                continue

        for deb in os.listdir('/tmp'):
            if deb.endswith('.deb'):
                self.offline.append((deb,
                 'Internal Flash',
                 '/tmp',
                 loadPNG(self.plugin_path + '/icons/deb.png')))

        self['info'].setText('Offline Install......')
        self['list'].setList(self.offline)

    def InstallPackage(self, filepath):
        self.call = True
        self.pinstall = False
        self.Package.update(self.Progress())
        self.Package.open(None)
        self.deb = self.debfile(filepath, self.Package)
        self.deps = self.deb.depends
        if len(self.deps) >= 1:
            for depends in self.deps:
                self.debian = depends[0][0]
                self.debianv = depends[0][1]
                self.debiano = depends[0][2]
                self.Data('Depends ' + self.debian + ' ' + self.debiano + ' ' + self.debianv + '\n')
                nPrint('Depends ' + self.debian + ' ' + self.debiano + ' ' + self.debianv + '\n')
                try:
                    self.pkg = self.Package[self.debian]
                    if not self.pkg.is_installed:
                        self.pkg.mark_install()
                        self.call = self.Package.commit(self.Progress())
                        if self.call:
                            self.Data('Install depend ' + self.debian + '-' + self.pkg.candidate.version + 'successfully\n')
                            nPrint('Install depend ' + self.debian + '-' + self.pkg.candidate.version + 'successfully\n')
                        if not self.call:
                            self.Data('Install depend ' + self.debian + '-' + self.pkg.candidate.version + ' failed\n')
                            nPrint('Install depend ' + self.debian + '-' + self.pkg.candidate.version + ' failed\n')
                    if self.pkg.is_installed:
                        self.Data('Package ' + self.debian + '-' + self.pkg.installed.version + ' is installed\n')
                except (SystemError,
                 AttributeError,
                 IOError,
                 OSError,
                 KeyError,
                 TypeError) as e:
                    nPrint(str(e))
                    self.Data(str(e))
                    self.call = False
                    break

        if self.call:
            try:
                self.deb.install(None)
                self.Package.open(None)
                self.pname = os.path.split(filepath)[1].split('_')[0]
                self.pkgvar = self.Package[self.pname]
                self.pinstall = self.pkgvar.is_installed
                if self.pinstall:
                    self.Data('Install package ' + filepath + ' successfully\n')
                    nPrint('Install package ' + filepath + ' successfully\n')
                if not self.pinstall:
                    self.Data('Install package ' + filepath + ' failed\n')
                    nPrint('Install package ' + filepath + ' failed\n')
            except (SystemError,
             AttributeError,
             IOError,
             OSError,
             KeyError,
             TypeError) as e:
                nPrint(str(e))
                self.Data(str(e))

        return self.pinstall

    def aktion(self):
        if self['list'].getCurrent() is not None:
            message = __('Do you really want to install the package? %s') % self['list'].getCurrent()[0]
            restartbox = self.session.openWithCallback(self.aktionCallback, MessageBox, message, MessageBox.TYPE_YESNO)
        return

    def aktionCallback(self, retValue=None):
        if retValue and self['list'].getCurrent() is not None:
            self.packagepath = self['list'].getCurrent()[2] + '/' + self['list'].getCurrent()[0]
            self.status = self.InstallPackage(self.packagepath)
            if self.status:
                restartbox = self.session.openWithCallback(self.restartGUI, MessageBox, __('Do you want to Restart now?'), MessageBox.TYPE_YESNO)
                restartbox.setTitle(__('Enigma2 Restart'))
        return

    def Data(self, data):
        self.DataList.append((data, None))
        self['statuslist'].setList(self.DataList)
        self['statuslist'].moveSelection('moveEnd')
        return

    def restartGUI(self, answer):
        if answer:
            self.session.open(TryQuitMainloop, 3)
        if not answer:
            self.close(False)

    def workFinished(self, callback = None):
        if self.working:
            self.working = False

    def cancel(self):
        self.close(False)