# /usr/lib/enigma2/python/Plugins/newnigma2/paketmanager/plugin.py
from Screens.MessageBox import MessageBox
from Plugins.Plugin import PluginDescriptor
from Tools.HardwareInfo import HardwareInfo
from Components.config import config, ConfigSubsection, ConfigIP, ConfigOnOff, ConfigInteger, ConfigText, ConfigSelection, ConfigYesNo, NoSave, configfile
from Plugins.newnigma2.tools.NewNigma2Stuff import __, nPrint
from Paketmanager import PKGMain, InstallLog
import subprocess, os, apt, apt_pkg
from updatecheck import MyUpdateChecker
from enigma import eConsoleAppContainer

config.plugins.paketmanager = ConfigSubsection()
config.plugins.paketmanager.ActivateFilter = NoSave(ConfigYesNo(default=False))
config.plugins.paketmanager.ShowPlugins = NoSave(ConfigYesNo(default=False))
config.plugins.paketmanager.ShowSkins = NoSave(ConfigYesNo(default=False))
config.plugins.paketmanager.ShowKernel = NoSave(ConfigYesNo(default=False))
config.plugins.paketmanager.ShowCamd = NoSave(ConfigYesNo(default=False))
config.plugins.paketmanager.ShowDreambox = NoSave(ConfigYesNo(default=False))
config.plugins.paketmanager.ShowPython = NoSave(ConfigYesNo(default=False))
config.plugins.paketmanager.ShowUpdates = NoSave(ConfigYesNo(default=False))
config.plugins.paketmanager.ShowUser = NoSave(ConfigYesNo(default=False))
config.plugins.paketmanager.User = NoSave(ConfigText(default='', fixed_size=False))
config.plugins.paketmanager.enableSkins = ConfigYesNo(default=False)
config.plugins.paketmanager.enableKernel = ConfigYesNo(default=False)
config.plugins.paketmanager.enablePlugins = ConfigYesNo(default=False)
config.plugins.paketmanager.enablePython = ConfigYesNo(default=False)

def Paketmanager_call(self):
    self.session.openWithCallback(self.PluginDownloadBrowserClosed, PKGMain, plugin_path)


def autostart(session, **kwargs):
    global updatechecker
    updatechecker = MyUpdateChecker(session, plugin_path)
    from Screens.PluginBrowser import PluginBrowser
    PluginBrowser.openExtensionmanager = Paketmanager_call


def Systemstarter(menuid, **kwargs):
    if menuid == 'systemsettings':
        return [(__('Manage additional software...'),
          main,
          __('Paketmanager'),
          70,
          'apt.png')]
    return []


def Backupstarter(menuid, **kwargs):
    if menuid == 'systemsettings':
        return [(__('Dreambox Backup'),
          DreamboxBackup,
          __('Paketmanager'),
          70,
          'apt.png')]
    return []


def Mainstarter(menuid, **kwargs):
    if menuid == 'mainmenu':
        return [(__('Manage additional software...'),
          main,
          __('Paketmanager'),
          70,
          'apt.png')]
    return []


def Camdstarter(menuid, **kwargs):
    if menuid == 'emustuff':
        return [(__('Add/remove camds'),
          emumain,
          __('Onlineinstaller for camds'),
          55,
          'apt.png')]
    return []


def PluginFilterstarter(menuid, **kwargs):
    if menuid == 'mainmenu':
        return [(__('Add/remove Plugins'),
          PluginsMain,
          __('Onlineinstaller for Plugins'),
          70,
          'apt.png')]
    return []


def SkinFilterstarter(menuid, **kwargs):
    if menuid == 'mainmenu':
        return [(__('Add/remove Skins'),
          SkinsMain,
          __('Onlineinstaller for Skins'),
          70,
          'apt.png')]
    return []


def KernelFilterstarter(menuid, **kwargs):
    if menuid == 'mainmenu':
        return [(__('Add/remove Kernel Module'),
          KernelMain,
          __('Onlineinstaller for Kernel Module'),
          70,
          'apt.png')]
    return []


def PythonFilterstarter(menuid, **kwargs):
    if menuid == 'mainmenu':
        return [(__('Add/remove Python Module'),
          PythonMain,
          __('Onlineinstaller for Python Module'),
          70,
          'apt.png')]
    return []


def main(session, **kwargs):
    print('[Paketmanager] start main')
    config.plugins.paketmanager.ActivateFilter.value = False
    config.plugins.paketmanager.ShowPlugins.value = False
    config.plugins.paketmanager.ShowSkins.value = False
    config.plugins.paketmanager.ShowKernel.value = False
    config.plugins.paketmanager.ShowCamd.value = False
    config.plugins.paketmanager.ShowDreambox.value = False
    config.plugins.paketmanager.ShowPython.value = False
    config.plugins.paketmanager.ShowUser.value = False
    session.open(PKGMain, plugin_path)


def emumain(session, **kwargs):
    print('[Paketmanager] start emumain')
    config.plugins.paketmanager.ActivateFilter.value = True
    config.plugins.paketmanager.ShowPlugins.value = False
    config.plugins.paketmanager.ShowSkins.value = False
    config.plugins.paketmanager.ShowKernel.value = False
    config.plugins.paketmanager.ShowCamd.value = True
    config.plugins.paketmanager.ShowDreambox.value = False
    config.plugins.paketmanager.ShowPython.value = False
    config.plugins.paketmanager.ShowUser.value = False
    session.open(PKGMain, plugin_path)


def PluginsMain(session, **kwargs):
    print('[Paketmanager] start PluginsMain')
    config.plugins.paketmanager.ActivateFilter.value = True
    config.plugins.paketmanager.ShowPlugins.value = True
    config.plugins.paketmanager.ShowSkins.value = False
    config.plugins.paketmanager.ShowKernel.value = False
    config.plugins.paketmanager.ShowCamd.value = False
    config.plugins.paketmanager.ShowDreambox.value = False
    config.plugins.paketmanager.ShowPython.value = False
    config.plugins.paketmanager.ShowUser.value = False
    session.open(PKGMain, plugin_path)


def SkinsMain(session, **kwargs):
    print('[Paketmanager] start SkinsMain')
    config.plugins.paketmanager.ActivateFilter.value = True
    config.plugins.paketmanager.ShowPlugins.value = False
    config.plugins.paketmanager.ShowSkins.value = True
    config.plugins.paketmanager.ShowKernel.value = False
    config.plugins.paketmanager.ShowCamd.value = False
    config.plugins.paketmanager.ShowDreambox.value = False
    config.plugins.paketmanager.ShowPython.value = False
    config.plugins.paketmanager.ShowUser.value = False
    session.open(PKGMain, plugin_path)


def KernelMain(session, **kwargs):
    print('[Paketmanager] start KernelMain')
    config.plugins.paketmanager.ActivateFilter.value = True
    config.plugins.paketmanager.ShowPlugins.value = False
    config.plugins.paketmanager.ShowSkins.value = False
    config.plugins.paketmanager.ShowKernel.value = True
    config.plugins.paketmanager.ShowCamd.value = False
    config.plugins.paketmanager.ShowDreambox.value = False
    config.plugins.paketmanager.ShowPython.value = False
    config.plugins.paketmanager.ShowUser.value = False
    session.open(PKGMain, plugin_path)


def PythonMain(session, **kwargs):
    print('[Paketmanager] start PythonMain')
    config.plugins.paketmanager.ActivateFilter.value = True
    config.plugins.paketmanager.ShowPlugins.value = False
    config.plugins.paketmanager.ShowSkins.value = False
    config.plugins.paketmanager.ShowKernel.value = False
    config.plugins.paketmanager.ShowCamd.value = False
    config.plugins.paketmanager.ShowDreambox.value = False
    config.plugins.paketmanager.ShowPython.value = True
    config.plugins.paketmanager.ShowUser.value = False
    session.open(PKGMain, plugin_path)


def DreamboxBackup(session, **kwargs):
    session.open(InstallLog, 8, None, None, plugin_path)
    return


def CfgSave():
    MyCFG = [config.plugins.paketmanager.ActivateFilter,
     config.plugins.paketmanager.ShowPlugins,
     config.plugins.paketmanager.ShowSkins,
     config.plugins.paketmanager.ShowKernel,
     config.plugins.paketmanager.ShowCamd,
     config.plugins.paketmanager.ShowDreambox,
     config.plugins.paketmanager.ShowPython,
     config.plugins.paketmanager.ShowUser]
    for Item in MyCFG:
        Item.save()


def Plugins(path, **kwargs):
    global plugin_path
    plugin_path = path
    list = []
    list.append(PluginDescriptor(name='Paketmanager', description=__('Packetmanager'), where=PluginDescriptor.WHERE_EXTENSIONSMENU, fnc=main))
    list.append(PluginDescriptor(where=[PluginDescriptor.WHERE_SESSIONSTART], fnc=autostart))
    list.append(PluginDescriptor(where=PluginDescriptor.WHERE_e2MENU, icon='apt.png', fnc=Systemstarter))
    list.append(PluginDescriptor(where=PluginDescriptor.WHERE_e2MENU, icon='apt.png', fnc=Backupstarter))
    list.append(PluginDescriptor(icon='apt.png', where=PluginDescriptor.WHERE_e2MENU, fnc=Mainstarter))
    list.append(PluginDescriptor(icon='apt.png', where=PluginDescriptor.WHERE_e2MENU, fnc=Camdstarter))
    if config.plugins.paketmanager.enablePlugins.value:
        list.append(PluginDescriptor(icon='apt.png', where=PluginDescriptor.WHERE_e2MENU, fnc=PluginFilterstarter))
    if config.plugins.paketmanager.enableSkins.value:
        list.append(PluginDescriptor(icon='apt.png', where=PluginDescriptor.WHERE_e2MENU, fnc=SkinFilterstarter))
    if config.plugins.paketmanager.enableKernel.value:
        list.append(PluginDescriptor(icon='apt.png', where=PluginDescriptor.WHERE_e2MENU, fnc=KernelFilterstarter))
    if config.plugins.paketmanager.enablePython.value:
        list.append(PluginDescriptor(icon='apt.png', where=PluginDescriptor.WHERE_e2MENU, fnc=PythonFilterstarter))
    return list