# /usr/lib/enigma2/python/Plugins/newnigma2/paketmanager/updatecheck.py
from Screens.MessageBox import MessageBox
from Components.config import config
from enigma import eTimer
from time import time, strftime, localtime
from Tools import Notifications
import apt, apt_pkg, socket, requests
from Plugins.newnigma2.paketmanager.Paketmanager import InstallLog, boxArch
from Plugins.newnigma2.tools.NewNigma2Stuff import __, nPrint

class MyUpdateChecker:

    def __init__(self, session, plugin_path):
        self.plugin_path = plugin_path
        self.session = session
        self.timer = eTimer()
        self.online = False
        
        # old code to check online status of the feed - give sometime online if server not reachable
        # self.con = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        # self.con.settimeout(2)
        # try:
            # self.con.connect(('feed.newnigma2.to', 80))
            # self.con.close()
            # self.online = True
            # nPrint('[UpdateCheck] we are online')
        # except socket.error as msg:
            # self.con.close()
            # nPrint('[UpdateCheck] we are offline')
        
        # new alternative better code to check online status of the feed
        try:
            r = requests.get('https://feed.newnigma2.to', timeout=3, verify=False)
            self.online = r.status_code == 200
        except requests.exceptions.RequestException as e:
            self.online = False
        
        if self.online:
            nPrint('[UpdateCheck] we are online')
            try:
                #old code to use addional self.cache.packages - perhaps with error buffer overflow
                #self.apt_pkg = apt_pkg
                #self.apt_pkg.init_config()
                #self.apt_pkg.init_system()
                #self.cache = self.apt_pkg.Cache()
                #self.Package = apt.Cache()
                #self.Package.update()
                #self.Package.open(None)
                #self.timer_conn = self.timer.timeout.connect(self.CheckForUpdate)
                #config.plugins.installer.check_update_notifier.addNotifier(self.configChange, initial_call=True)
                #if config.plugins.installer.check_update_on_boot.value:
                #    self.CheckForUpdate()
                
                #use only self.Package and self.Package._cache.packages instead additional self.cache.packages
                #use self.Package.update() only if option "check update on boot" is activated
                self.Package = apt.Cache()
                self.timer_conn = self.timer.timeout.connect(self.CheckForUpdate)
                if config.plugins.installer.check_update_on_boot.value:
                    nPrint('[UpdateCheck] check for update on boot')
                    self.CheckForUpdate()
                else:
                    nPrint('[UpdateCheck] check on boot not activated')
                    self.Package.open(None)
                
                config.plugins.installer.check_update_notifier.addNotifier(self.configChange, initial_call=True)
            except (IOError, OSError, KeyError) as e:
                nPrint(str(e))
        else:
            nPrint('[UpdateCheck] we are offline')
        
        return

    def configChange(self, configElement = None):
        if self.timer.isActive():
            self.timer.stop()
        nPrint('[UpdateCheck] timer changed')
        self.startTimer()

    def startTimer(self):
        self.value = int(config.plugins.installer.check_update_notifier.value)
        if self.value > 0:
            nextupdate = strftime('%c', localtime(time() + self.value))
            nPrint('[UpdateCheck] next check at ' + nextupdate)
            self.timer.startLongTimer(self.value)
        else:
            nPrint('[UpdateCheck] is deactivated')

    def CheckForUpdate(self):
        nPrint('[UpdateCheck] Package.update')
        self.Package.update()
        self.Package.open(None)
        self.number = 0
        self.upgradeable = ''
        nPrint('[UpdateCheck] GetPackages Online')
        upgrades_available = False
        #for pkg in self.cache.packages:
        for pkg in self.Package._cache.packages:
            try:
                #list only packages for used architecure
                if pkg.architecture != boxArch:
                    #nPrint('[UpdateCheck] skip package for wrong arch: %s, %s, %s' % (pkg.architecture, boxArch, pkg.name))
                    continue # skip feed-packages for other boxArch
                self.pkgvar = self.Package[pkg.name]
                if not self.Package.is_virtual_package(pkg.name):
                    if self.pkgvar.is_installed:
                        if self.pkgvar.is_upgradable:
                            self.number += 1
                            upgrades_available = True
                            self.upgradeable += pkg.name + ','
            except KeyError:
                continue

        if self.number > 0:
            nPrint('[UpdateCheck] %d updates available for installed Packages' % self.number)
            nPrint('[UpdateCheck] updatelist')
            nPrint('[UpdateCheck] ' + self.upgradeable)
            self.upgradableListFinished(upgrades_available, self.upgradeable, self.number)
        if self.number == 0:
            nPrint('[UpdateCheck] no updates available')

    def upgradableListFinished(self, update, deb, number):
        if update:
            Notifications.AddNotificationWithCallback(self.runUpgrade, MessageBox, __('For your Firmware are %s updates available.') % str(self.number) + '\n' + __('For further information visit http://newnigma2.to.') + '\n' + __('Do you want to start the firmware upgrade now ?'), timeout=10, default=False)
        self.startTimer()

    def runUpgrade(self, result):
        if result:
            self.session.open(InstallLog, 3, None, None, self.plugin_path)
        return